/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import ca.odell.glazedlists.gui.TableFormat;
import java.util.Comparator;

public class EventListColumnComparator<E>
implements Comparator<E> {
    private TableFormat<E> tableFormat;
    private int column;
    private Comparator comparator = null;

    public EventListColumnComparator(TableFormat<E> tableFormat, int column, Comparator comparator) {
        this.column = column;
        this.tableFormat = tableFormat;
        this.comparator = comparator;
    }

    @Override
    public int compare(E alpha, E beta) {
        Object alphaField = this.tableFormat.getColumnValue(alpha, this.column);
        Object betaField = this.tableFormat.getColumnValue(beta, this.column);
        try {
            return this.comparator.compare(alphaField, betaField);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Cannot compare \"" + alphaField + "\" to \"" + betaField + "\" in " + this.tableFormat.getClass().getName() + ", column " + this.column);
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventListColumnComparator that = (EventListColumnComparator)o;
        if (this.column != that.column) {
            return false;
        }
        if (!((Object)this.comparator).equals(that.comparator)) {
            return false;
        }
        return this.tableFormat.equals(that.tableFormat);
    }

    public int hashCode() {
        int result = this.tableFormat.hashCode();
        result = 29 * result + this.column;
        result = 29 * result + this.comparator.hashCode();
        return result;
    }
}

