/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadState;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.upload.table.FinishedUploadSelected;
import org.limewire.ui.swing.upload.table.UploadPopupMenu;
import org.limewire.ui.swing.upload.table.UploadPopupMenuFactory;
import org.limewire.ui.swing.upload.table.UploadTable;
import org.limewire.ui.swing.upload.table.UploadTableFactory;

public class LimeWireUiUploadModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(UploadPopupMenuFactory.class).toProvider(FactoryProvider.newFactory(UploadPopupMenuFactory.class, UploadPopupMenu.class));
        this.bind(UploadTableFactory.class).toProvider(FactoryProvider.newFactory(UploadTableFactory.class, UploadTable.class));
    }

    @Provides
    @FinishedUploadSelected
    List<File> selectedFiles(UploadMediator uploadMediator) {
        ArrayList<File> files = new ArrayList<File>();
        List<UploadItem> uploadItems = uploadMediator.getSelectedUploads();
        for (UploadItem item : uploadItems) {
            if (item.getState() != UploadState.DONE) continue;
            files.addAll(item.getCompleteFiles());
        }
        return files;
    }
}

