/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import ca.odell.glazedlists.gui.TableFormat;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.limewire.ui.swing.table.VisibleTableFormat;

public class TableColumnSelector {
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JXTable table;
    private final ColumnListener listener = new ColumnListener();

    public TableColumnSelector(JXTable table, VisibleTableFormat format) {
        this.table = table;
        this.addColumnHeader(format);
    }

    private void addColumnHeader(VisibleTableFormat format) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < format.getColumnCount(); ++i) {
            if (!format.isColumnHideable(i)) continue;
            map.put(format.getColumnName(i), i);
        }
        TreeSet sortedSet = new TreeSet(map.keySet());
        for (String value : sortedSet) {
            JMenuItem item = this.createMenuItem(format, (Integer)map.get(value));
            item.addActionListener(this.listener);
            this.popupMenu.add(item);
        }
    }

    private JMenuItem createMenuItem(TableFormat format, int index) {
        return new JCheckBoxMenuItem(format.getColumnName(index), this.table.getColumnExt(format.getColumnName(index)).isVisible());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    private class ColumnListener
    implements ActionListener {
        private ColumnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String columnName = e.getActionCommand();
            TableColumnExt column = TableColumnSelector.this.table.getColumnExt(columnName);
            if (column.isVisible() && TableColumnSelector.this.table.getColumnCount(false) == 1) {
                return;
            }
            column.setVisible(!column.isVisible());
        }
    }
}

