/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import org.limewire.ui.swing.settings.TablesHandler;

public class ColumnStateInfo {
    private final int modelIndex;
    private final String id;
    private final String name;
    private final int defaultWidth;
    private final int maxWidth;
    private final boolean isShownAtStartup;
    private final boolean isHideable;
    private int preferredIndex;
    private final boolean isDefaultlyShown;

    public ColumnStateInfo(int modelIndex, String id, String name, int defaultWidth, boolean isShownAtStartup, boolean isHideable) {
        this(modelIndex, id, name, defaultWidth, -1, isShownAtStartup, isHideable);
    }

    public ColumnStateInfo(int modelIndex, String id, String name, int defaultWidth, int maxWidth, boolean isShownAtStartup, boolean isHideable) {
        this.id = id;
        this.name = name;
        this.isHideable = isHideable;
        this.isDefaultlyShown = isShownAtStartup;
        this.modelIndex = modelIndex;
        this.isShownAtStartup = TablesHandler.getVisibility(id, isShownAtStartup).getValue();
        this.defaultWidth = TablesHandler.getWidth(id, defaultWidth).getValue();
        this.maxWidth = maxWidth;
        this.preferredIndex = TablesHandler.getOrder(id, modelIndex).getValue();
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getPreferredViewIndex() {
        return this.preferredIndex;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean isShown() {
        return this.isShownAtStartup;
    }

    public boolean isHideable() {
        return this.isHideable;
    }

    public boolean isDefaultlyShown() {
        return this.isDefaultlyShown;
    }

    public void setPreferredViewIndex(int i) {
        this.preferredIndex = i;
    }
}

