/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CleanStringCache {
    private final Matcher matcher;
    private final String replacement;
    private final Map<String, String> cache;

    public CleanStringCache(Pattern pattern, String replacement) {
        this.matcher = pattern.matcher("");
        this.replacement = replacement;
        this.cache = new WeakHashMap<String, String>();
    }

    public String getCleanString(String name) {
        String cleanedString = this.cache.get(name);
        if (cleanedString == null) {
            cleanedString = this.cleanString(name);
            this.cache.put(name, cleanedString);
        }
        return cleanedString;
    }

    public String cleanString(String string) {
        this.matcher.reset(string);
        string = this.matcher.replaceAll(this.replacement);
        return string;
    }

    public boolean matches(String string1, String string2) {
        return this.getCleanString(string1).equalsIgnoreCase(this.getCleanString(string2));
    }
}

