/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.player.api.PlayerState;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.MarqueeButton;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.player.AudioPlayerMediator;
import org.limewire.ui.swing.player.PlayerMediatorListener;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class MiniPlayerPanel
extends JPanel {
    @Resource
    private Icon pauseIcon;
    @Resource
    private Icon pauseIconPressed;
    @Resource
    private Icon pauseIconRollover;
    @Resource
    private Icon playIcon;
    @Resource
    private Icon playIconPressed;
    @Resource
    private Icon playIconRollover;
    @Resource
    private Color foregroundColor;
    @Resource
    private Font font;
    private JButton playPauseButton;
    private MarqueeButton statusButton;
    private final Provider<AudioPlayerMediator> playerMediator;
    private final LibraryMediator libraryMediator;
    private boolean isInitialized = false;

    @Inject
    public MiniPlayerPanel(Provider<AudioPlayerMediator> playerMediator, LibraryMediator libraryMediator) {
        super(new MigLayout("insets 0", "4[][]", "0[]0"));
        this.playerMediator = playerMediator;
        this.libraryMediator = libraryMediator;
    }

    private void initialize() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            GuiUtils.assignResources(this);
            this.setOpaque(false);
            this.playPauseButton = new JButton();
            this.playPauseButton.setMargin(new Insets(0, 0, 0, 0));
            this.playPauseButton.setBorderPainted(false);
            this.playPauseButton.setContentAreaFilled(false);
            this.playPauseButton.setFocusPainted(false);
            this.playPauseButton.setRolloverEnabled(true);
            this.playPauseButton.setIcon(this.playIcon);
            Dimension playPauseDimensions = new Dimension(this.playIcon.getIconWidth(), this.playIcon.getIconHeight());
            this.playPauseButton.setMaximumSize(playPauseDimensions);
            this.playPauseButton.setPreferredSize(playPauseDimensions);
            this.playPauseButton.setRolloverIcon(this.playIconRollover);
            this.playPauseButton.setPressedIcon(this.playIconPressed);
            this.playPauseButton.setHideActionText(true);
            this.playPauseButton.addActionListener(new PlayListener());
            this.statusButton = new MarqueeButton(I18n.tr("Nothing selected"), 16);
            Dimension statusButtonDimensions = new Dimension(Integer.MAX_VALUE, this.playIcon.getIconHeight());
            this.statusButton.setMaximumSize(statusButtonDimensions);
            this.statusButton.setFont(this.font);
            this.statusButton.setForeground(this.foregroundColor);
            this.statusButton.addActionListener(new ShowPlayerListener());
            this.add((Component)this.playPauseButton, "gapbottom 0, gaptop 0");
            this.add((Component)this.statusButton, "gapbottom 0, gaptop 0");
            this.setMaximumSize(this.getPreferredSize());
        }
    }

    @Inject
    void register() {
        this.playerMediator.get().addMediatorListener(new PlayerListener());
        SwingUiSettings.PLAYER_ENABLED.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MiniPlayerPanel.this.setVisible(false);
                    }
                });
            }
        });
    }

    private boolean isPlaying() {
        return this.playerMediator.get().getStatus() == PlayerState.PLAYING || this.playerMediator.get().getStatus() == PlayerState.SEEKING_PLAY;
    }

    private void setPlaying(boolean playing) {
        if (playing) {
            this.playerMediator.get().resume();
        } else {
            this.playerMediator.get().pause();
        }
    }

    private class PlayerListener
    implements PlayerMediatorListener {
        private PlayerListener() {
        }

        @Override
        public void progressUpdated(float progress) {
        }

        @Override
        public void songChanged(String name) {
            MiniPlayerPanel.this.initialize();
            MiniPlayerPanel.this.statusButton.setText(name);
            MiniPlayerPanel.this.statusButton.getToolTip().setTipText(name);
            if (!MiniPlayerPanel.this.isVisible()) {
                MiniPlayerPanel.this.setVisible(true);
            }
            MiniPlayerPanel.this.statusButton.start();
        }

        @Override
        public void stateChanged(PlayerState state) {
            MiniPlayerPanel.this.initialize();
            if (state == PlayerState.PLAYING || state == PlayerState.RESUMED) {
                MiniPlayerPanel.this.playPauseButton.setIcon(MiniPlayerPanel.this.pauseIcon);
                MiniPlayerPanel.this.playPauseButton.setRolloverIcon(MiniPlayerPanel.this.pauseIconRollover);
                MiniPlayerPanel.this.playPauseButton.setPressedIcon(MiniPlayerPanel.this.pauseIconPressed);
                MiniPlayerPanel.this.statusButton.start();
            } else if (state == PlayerState.STOPPED || state == PlayerState.EOM || state == PlayerState.UNKNOWN || state == PlayerState.NO_SOUND_DEVICE) {
                MiniPlayerPanel.this.setVisible(false);
                MiniPlayerPanel.this.statusButton.stop();
            } else if (state == PlayerState.PAUSED) {
                MiniPlayerPanel.this.playPauseButton.setIcon(MiniPlayerPanel.this.playIcon);
                MiniPlayerPanel.this.playPauseButton.setRolloverIcon(MiniPlayerPanel.this.playIconRollover);
                MiniPlayerPanel.this.playPauseButton.setPressedIcon(MiniPlayerPanel.this.playIconPressed);
                MiniPlayerPanel.this.statusButton.stop();
            }
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MiniPlayerPanel.this.setPlaying(!MiniPlayerPanel.this.isPlaying());
        }
    }

    private class ShowPlayerListener
    implements ActionListener {
        private ShowPlayerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File currentFile = ((AudioPlayerMediator)MiniPlayerPanel.this.playerMediator.get()).getCurrentMediaFile();
            if (currentFile != null) {
                MiniPlayerPanel.this.libraryMediator.selectInLibrary(currentFile);
            }
        }
    }
}

