/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter.factories;

import com.google.inject.Inject;
import java.awt.Color;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ButtonBackgroundPainter;
import org.limewire.ui.swing.painter.ButtonForegroundPainter;
import org.limewire.ui.swing.painter.DarkButtonBackgroundPainter;
import org.limewire.ui.swing.painter.FlatButtonBackgroundPainter;
import org.limewire.ui.swing.painter.GreenButtonBackgroundPainter;
import org.limewire.ui.swing.painter.LightButtonBackgroundPainter;
import org.limewire.ui.swing.painter.PopupButtonBackgroundPainter;
import org.limewire.ui.swing.util.GuiUtils;

public class ButtonPainterFactory {
    @Resource
    private Color miniHoverTextForeground;
    @Resource
    private Color miniDownTextForeground;
    @Resource
    private Color darkFullHoverTextForeground;
    @Resource
    private Color darkFullDownTextForeground;
    @Resource
    private Color darkFullDisabledTextForeground;
    @Resource
    private int miniArcWidth;
    @Resource
    private int miniArcHeight;
    @Resource
    private Color miniBackgroundPressed;
    @Resource
    private Color miniBackgroundRollover;
    @Resource
    private int linkArcWidth;
    @Resource
    private int linkArcHeight;
    @Resource
    private Color linkBackgroundPressed;
    @Resource
    private Color linkBackgroundRollover;
    @Resource
    private Color linkDownTextForeground;

    @Inject
    ButtonPainterFactory() {
        GuiUtils.assignResources(this);
    }

    public ButtonForegroundPainter createMiniButtonForegroundPainter() {
        return new ButtonForegroundPainter(this.miniHoverTextForeground, this.miniDownTextForeground, Color.GRAY);
    }

    public ButtonForegroundPainter createLinkButtonForegroundPainter() {
        return new ButtonForegroundPainter(null, this.linkDownTextForeground, null, ButtonForegroundPainter.FontTransform.NO_CHANGE, ButtonForegroundPainter.FontTransform.REMOVE_UNDERLINE, ButtonForegroundPainter.FontTransform.NO_CHANGE);
    }

    public ButtonForegroundPainter createLightFullButtonForegroundPainter() {
        return new ButtonForegroundPainter();
    }

    public ButtonForegroundPainter createDarkFullButtonForegroundPainter() {
        return new ButtonForegroundPainter(this.darkFullHoverTextForeground, this.darkFullDownTextForeground, this.darkFullDisabledTextForeground);
    }

    public PopupButtonBackgroundPainter createMiniButtonBackgroundPainter() {
        return new PopupButtonBackgroundPainter(this.miniBackgroundPressed, this.miniBackgroundRollover, this.miniArcWidth, this.miniArcHeight);
    }

    public PopupButtonBackgroundPainter createLinkButtonBackgroundPainter() {
        return new PopupButtonBackgroundPainter(this.linkBackgroundPressed, this.linkBackgroundRollover, this.linkArcWidth, this.linkArcHeight);
    }

    public ButtonBackgroundPainter createLightFullButtonBackgroundPainter() {
        return new LightButtonBackgroundPainter();
    }

    public ButtonBackgroundPainter createGreenFullButtonBackgroundPainter() {
        return new GreenButtonBackgroundPainter();
    }

    public ButtonBackgroundPainter createDarkFullButtonBackgroundPainter(ButtonBackgroundPainter.DrawMode mode, BorderPainter.AccentType accent) {
        return new DarkButtonBackgroundPainter(mode, accent);
    }

    public FlatButtonBackgroundPainter createFlatButtonBackgroundPainter() {
        return new FlatButtonBackgroundPainter();
    }
}

