/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.event.MenuListener;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.action.MnemonicMenu;
import org.limewire.ui.swing.advanced.AdvancedToolsPanel;
import org.limewire.ui.swing.mainframe.OptionsAction;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.SearchCategoryUtils;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.search.SearchNavItem;
import org.limewire.ui.swing.search.SearchNavigator;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

class ToolsMenu
extends MnemonicMenu {
    private final JMenu whatsNewSubmenu;
    private final Provider<AdvancedToolsPanel> advancedToolsPanelProvider;
    private final Provider<SearchHandler> searchHandlerProvider;
    private final Provider<SearchNavigator> searchNavigatorProvider;
    private final Provider<OptionsAction> optionsAction;
    private AdvancedToolsPanel advancedTools = null;

    @Inject
    public ToolsMenu(Provider<AdvancedToolsPanel> advancedToolsPanelProvider, Provider<SearchHandler> searchHandlerProvider, Provider<SearchNavigator> searchNavigatorProvider, Provider<OptionsAction> optionsAction) {
        super(I18n.tr("&Tools"));
        this.advancedToolsPanelProvider = advancedToolsPanelProvider;
        this.searchHandlerProvider = searchHandlerProvider;
        this.searchNavigatorProvider = searchNavigatorProvider;
        this.optionsAction = optionsAction;
        this.whatsNewSubmenu = this.createWhatsNewSubmenu();
    }

    @Override
    public void createMenuItems() {
        this.add(new AbstractAction(I18n.tr("Advanced &Search")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchNavItem item = ((SearchNavigator)ToolsMenu.this.searchNavigatorProvider.get()).addAdvancedSearch();
                item.select();
            }
        });
        this.add(this.whatsNewSubmenu);
        this.addSeparator();
        this.add(new AbstractAction(I18n.tr("&Advanced Tools...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowAdapter closeListener = null;
                if (ToolsMenu.this.advancedTools == null) {
                    ToolsMenu.this.advancedTools = (AdvancedToolsPanel)ToolsMenu.this.advancedToolsPanelProvider.get();
                    closeListener = new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            ToolsMenu.this.advancedTools = null;
                        }
                    };
                }
                ToolsMenu.this.advancedTools.display(closeListener);
            }
        });
        if (!OSUtils.isMacOSX()) {
            this.addSeparator();
            this.add(this.optionsAction.get());
        }
    }

    @Override
    public void addMenuListener(MenuListener listener) {
        super.addMenuListener(listener);
        this.whatsNewSubmenu.addMenuListener(listener);
    }

    private JMenu createWhatsNewSubmenu() {
        MnemonicMenu menu = new MnemonicMenu(I18n.tr("&What's New Search")){

            @Override
            public void createMenuItems() {
                for (final SearchCategory category : SearchCategory.values()) {
                    if (category == SearchCategory.OTHER) continue;
                    AbstractAction action = new AbstractAction(SearchCategoryUtils.getWhatsNewMenuName(category)){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ((SearchHandler)ToolsMenu.this.searchHandlerProvider.get()).doSearch(DefaultSearchInfo.createWhatsNewSearch(category));
                        }
                    };
                    this.add(action);
                }
            }
        };
        return menu;
    }
}

