/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.library.FileItem;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.AbstractColumnStateFormat;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.EventListTableSortFormat;

public abstract class AbstractLibraryFormat<T extends FileItem>
extends AbstractColumnStateFormat<T>
implements EventListTableSortFormat {
    private final String sortID;
    private final int sortedColumn;
    private final boolean isAscending;
    private final int actionIndex;

    public AbstractLibraryFormat(int actionIndex, String sortID, int sortedColumn, boolean isAscending, ColumnStateInfo ... columnInfo) {
        super(columnInfo);
        this.sortID = sortID;
        this.sortedColumn = sortedColumn;
        this.isAscending = isAscending;
        this.actionIndex = actionIndex;
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    @Override
    public T setColumnValue(T baseObject, Object editedValue, int column) {
        return baseObject;
    }

    @Override
    public boolean isEditable(T baseObject, int column) {
        return column == this.actionIndex;
    }

    public int getActionColumn() {
        return this.actionIndex;
    }

    @Override
    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public List<SortKey> getPreSortColumns() {
        return Collections.emptyList();
    }

    @Override
    public boolean getSortOrder() {
        return this.isAscending;
    }

    @Override
    public String getSortOrderID() {
        return this.sortID;
    }

    @Override
    public int getSortedColumn() {
        return this.sortedColumn;
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        return Arrays.asList(new SortKey(TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() ? SortOrder.ASCENDING : SortOrder.DESCENDING, TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue()));
    }

    @Override
    public Comparator getColumnComparator(int column) {
        return this.getLimeComparator();
    }
}

