/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import com.google.inject.Inject;
import java.awt.Point;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.TransferHandler;
import org.apache.commons.logging.Log;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.dnd.LocalFileListTransferHandler;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorTable;
import org.limewire.ui.swing.warnings.LibraryWarningController;

class LibraryNavTransferHandler
extends LocalFileListTransferHandler {
    private static final Log LOG = LogFactory.getLog(LibraryNavTransferHandler.class);
    private LocalFileList localFileList = null;

    @Inject
    public LibraryNavTransferHandler(LibraryWarningController librarySupport) {
        super(librarySupport);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        try {
            if (info.getComponent() instanceof LibraryNavigatorTable) {
                LibraryNavigatorTable libraryNavigatorTable = (LibraryNavigatorTable)info.getComponent();
                TransferHandler.DropLocation dropLocation = info.getDropLocation();
                Point point = dropLocation.getDropPoint();
                int column = libraryNavigatorTable.columnAtPoint(point);
                int row = libraryNavigatorTable.rowAtPoint(point);
                if (column < 0 || row < 0) {
                    return false;
                }
                LibraryNavItem libraryNavItem = (LibraryNavItem)libraryNavigatorTable.getValueAt(row, column);
                if (libraryNavItem != null) {
                    this.localFileList = libraryNavItem.getLocalFileList();
                    return super.canImport(info);
                }
            }
            return false;
        }
        catch (RuntimeException e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
        catch (Error e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            if (info.getComponent() instanceof LibraryNavigatorTable && info.isDrop()) {
                LibraryNavigatorTable libraryNavigatorTable = (LibraryNavigatorTable)info.getComponent();
                TransferHandler.DropLocation dropLocation = info.getDropLocation();
                Point point = dropLocation.getDropPoint();
                int column = libraryNavigatorTable.columnAtPoint(point);
                int row = libraryNavigatorTable.rowAtPoint(point);
                if (column < 0 || row < 0) {
                    return false;
                }
                LibraryNavItem libraryNavItem = (LibraryNavItem)libraryNavigatorTable.getValueAt(row, column);
                if (libraryNavItem != null) {
                    this.localFileList = libraryNavItem.getLocalFileList();
                    return super.importData(info);
                }
            }
            return false;
        }
        catch (RuntimeException e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
        catch (Error e) {
            LOG.error("Error importing drop data.", e);
            throw e;
        }
    }

    @Override
    public LocalFileList getLocalFileList() {
        return this.localFileList;
    }

    @Override
    protected List<File> getSelectedFiles() {
        return Collections.emptyList();
    }
}

