/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.actions;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.jdesktop.application.Resource;
import org.limewire.concurrent.FutureEvent;
import org.limewire.core.settings.FriendSettings;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventUtils;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;

public class StatusActions {
    @Resource
    private Icon available;
    @Resource
    private Icon doNotDisturb;
    private final Action availableAction;
    private final Action doNotDisturbAction;
    private final JCheckBoxMenuItem availableItem;
    private final JCheckBoxMenuItem doNotDisturbItem;
    private final EventBean<FriendConnectionEvent> friendConnectionEventBean;
    private final ButtonGroup statusButtonGroup = new ButtonGroup();

    @Inject
    public StatusActions(EventBean<FriendConnectionEvent> friendConnectionEventBean) {
        this.friendConnectionEventBean = friendConnectionEventBean;
        GuiUtils.assignResources(this);
        this.availableAction = new AbstractAction(I18n.tr("&Available")){
            {
                this.putValue("SmallIcon", StatusActions.this.available);
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(StatusActions.this.friendConnectionEventBean);
                if (friendConnection != null && friendConnection.supportsMode()) {
                    friendConnection.setMode(FriendPresence.Mode.available).addFutureListener(new EventListener<FutureEvent<Void>>(){

                        @Override
                        public void handleEvent(FutureEvent<Void> event) {
                            if (event.getType() == FutureEvent.Type.SUCCESS) {
                                FriendSettings.DO_NOT_DISTURB.setValue(false);
                            }
                        }
                    });
                }
            }
        };
        this.doNotDisturbAction = new AbstractAction(I18n.tr("&Do Not Disturb")){
            {
                this.putValue("SmallIcon", StatusActions.this.doNotDisturb);
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(StatusActions.this.friendConnectionEventBean);
                if (friendConnection != null && friendConnection.supportsMode()) {
                    friendConnection.setMode(FriendPresence.Mode.dnd).addFutureListener(new EventListener<FutureEvent<Void>>(){

                        @Override
                        public void handleEvent(FutureEvent<Void> event) {
                            if (event.getType() == FutureEvent.Type.SUCCESS) {
                                FriendSettings.DO_NOT_DISTURB.setValue(true);
                            }
                        }
                    });
                }
            }
        };
        this.availableItem = new JCheckBoxMenuItem(this.availableAction);
        this.doNotDisturbItem = new JCheckBoxMenuItem(this.doNotDisturbAction);
        this.updateSignedInStatus();
        FriendSettings.DO_NOT_DISTURB.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusActions.this.updateSignedInStatus();
                    }
                });
            }
        });
    }

    public void updateSignedInStatus() {
        boolean signedIn;
        FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(this.friendConnectionEventBean);
        boolean bl = signedIn = friendConnection != null && friendConnection.isLoggedIn() && friendConnection.supportsMode();
        if (signedIn) {
            this.statusButtonGroup.remove(this.availableItem);
            this.statusButtonGroup.remove(this.doNotDisturbItem);
            this.statusButtonGroup.add(this.availableItem);
            this.statusButtonGroup.add(this.doNotDisturbItem);
            boolean dndBool = FriendSettings.DO_NOT_DISTURB.getValue();
            this.availableItem.setSelected(!dndBool);
            this.doNotDisturbItem.setSelected(dndBool);
        } else {
            this.statusButtonGroup.remove(this.availableItem);
            this.statusButtonGroup.remove(this.doNotDisturbItem);
            this.availableItem.setSelected(false);
            this.doNotDisturbItem.setSelected(false);
        }
        this.availableAction.setEnabled(signedIn);
        this.doNotDisturbAction.setEnabled(signedIn);
    }

    public JMenuItem getAvailableMenuItem() {
        return this.availableItem;
    }

    public JMenuItem getDnDMenuItem() {
        return this.doNotDisturbItem;
    }
}

