/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.RolloverCursorListener;
import org.limewire.ui.swing.filter.AbstractFilter;
import org.limewire.ui.swing.filter.FilterInspectionUtils;
import org.limewire.ui.swing.filter.FilterPopupPanel;
import org.limewire.ui.swing.filter.FilterType;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.PropertyMatcher;
import org.limewire.ui.swing.filter.UniqueListFactory;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.util.Objects;

class PropertyFilter<E extends FilterableItem>
extends AbstractFilter<E> {
    private final FilterType filterType;
    private final FilePropertyKey propertyKey;
    private final Provider<IconManager> iconManager;
    private final JPanel panel = new JPanel();
    private final JLabel propertyLabel = new JLabel();
    private final JXList list = new JXList();
    private final HyperlinkButton moreButton = new HyperlinkButton();
    private EventList<Object> propertyList;
    private FilterList<Object> nonNullList;
    private UniqueListFactory<Object> uniqueListFactory;
    private UniqueList<Object> uniqueList;
    private DefaultEventSelectionModel<Object> selectionModel;
    private DefaultEventSelectionModel<Object> popupSelectionModel;
    private FilterPopupPanel morePopupPanel;

    public PropertyFilter(EventList<E> resultsList, FilterType filterType, FilePropertyKey propertyKey, Provider<IconManager> iconManager) {
        if (filterType == FilterType.PROPERTY && propertyKey == null) {
            throw new IllegalArgumentException("Property filter cannot use null key");
        }
        this.filterType = filterType;
        this.propertyKey = propertyKey;
        this.iconManager = iconManager;
        AbstractFilter.FilterResources resources = this.getResources();
        this.panel.setLayout(new MigLayout("insets 0 0 0 0, gap 0!, hidemode 3", "[left,grow]", ""));
        this.panel.setOpaque(false);
        this.propertyLabel.setFont(resources.getHeaderFont());
        this.propertyLabel.setForeground(resources.getHeaderColor());
        this.propertyLabel.setText(this.getPropertyText());
        this.list.setCellRenderer((ListCellRenderer)new PropertyCellRenderer(resources.getBackground(), BorderFactory.createEmptyBorder(1, 7, 0, 7)));
        this.list.setFont(resources.getRowFont());
        this.list.setForeground(resources.getRowColor());
        this.list.setOpaque(false);
        this.list.setRolloverEnabled(true);
        this.list.setSelectionMode(0);
        this.list.setHighlighters(new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, resources.getHighlightBackground(), resources.getHighlightForeground()));
        new RolloverCursorListener().install(this.list);
        this.moreButton.setAction(new MoreAction());
        this.moreButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 1));
        this.moreButton.setContentAreaFilled(false);
        this.moreButton.setFocusPainted(false);
        this.moreButton.setFont(resources.getRowFont());
        this.moreButton.setHorizontalTextPosition(10);
        this.moreButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PropertyFilter.this.morePopupPanel != null) {
                    PropertyFilter.this.morePopupPanel.setPopupTriggered(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PropertyFilter.this.morePopupPanel != null) {
                    PropertyFilter.this.morePopupPanel.setPopupTriggered(false);
                }
            }
        });
        this.initialize(resultsList);
        this.list.setPrototypeCellValue("Type");
        int listHeight = 3 * this.list.getFixedCellHeight();
        this.panel.add((Component)this.propertyLabel, "gap 6 6, wrap");
        this.panel.add((Component)this.list, "hmax " + listHeight + ", grow, wrap");
        this.panel.add((Component)this.moreButton, "gap 6 6");
    }

    private void initialize(EventList<E> resultsList) {
        this.propertyList = this.createPropertyList(resultsList);
        this.nonNullList = this.createNonNullList(this.propertyList);
        this.uniqueListFactory = new UniqueListFactory<Object>(this.nonNullList, new PropertyComparator(this.filterType, this.propertyKey));
        this.uniqueListFactory.setName(this.getPropertyText());
        this.uniqueList = this.uniqueListFactory.getUniqueList();
        this.propertyLabel.setVisible(this.uniqueList.size() > 0);
        this.moreButton.setVisible(this.uniqueList.size() > 3);
        this.uniqueList.addListEventListener(new ListEventListener<Object>(){

            @Override
            public void listChanged(ListEvent listChanges) {
                if (!PropertyFilter.this.propertyLabel.isVisible() && PropertyFilter.this.uniqueList.size() > 0) {
                    PropertyFilter.this.propertyLabel.setVisible(true);
                } else if (PropertyFilter.this.propertyLabel.isVisible() && PropertyFilter.this.uniqueList.size() < 1) {
                    PropertyFilter.this.propertyLabel.setVisible(false);
                }
                if (!PropertyFilter.this.moreButton.isVisible() && PropertyFilter.this.uniqueList.size() > 3) {
                    PropertyFilter.this.moreButton.setVisible(true);
                } else if (PropertyFilter.this.moreButton.isVisible() && PropertyFilter.this.uniqueList.size() < 4) {
                    PropertyFilter.this.moreButton.setVisible(false);
                }
            }
        });
        SortedList<Object> sortedList = GlazedListsFactory.sortedList(this.uniqueList, new PropertyCountComparator());
        DefaultEventListModel<Object> listModel = new DefaultEventListModel<Object>(sortedList);
        this.selectionModel = new DefaultEventSelectionModel<Object>(sortedList);
        this.list.setModel(listModel);
        this.list.setSelectionModel(this.selectionModel);
        this.selectionModel.addListSelectionListener(new SelectionListener(this.selectionModel));
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void reset() {
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
        if (this.popupSelectionModel != null) {
            this.popupSelectionModel.clearSelection();
        }
        this.deactivate();
    }

    @Override
    public void dispose() {
        this.uniqueListFactory.dispose();
        this.propertyList.dispose();
    }

    @Override
    protected void activate(String activeText, Matcher<E> matcher) {
        super.activate(activeText, matcher);
        this.getComponent().setVisible(false);
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.getComponent().setVisible(true);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append("type=").append((Object)this.filterType);
        buf.append(", property=").append((Object)this.propertyKey);
        buf.append(", uniqueItems=").append(this.uniqueList.size());
        buf.append(", active=").append(this.isActive());
        EventList<Object> selectedList = this.selectionModel.getSelected();
        buf.append(", selection=").append(selectedList.size() > 0 ? selectedList.get(0) : "null");
        buf.append("]");
        return buf.toString();
    }

    private String getPropertyText() {
        switch (this.filterType) {
            case EXTENSION: {
                return I18n.tr("Extensions");
            }
            case PROPERTY: {
                switch (this.propertyKey) {
                    case AUTHOR: {
                        return I18n.tr("Artists");
                    }
                    case ALBUM: {
                        return I18n.tr("Albums");
                    }
                    case GENRE: {
                        return I18n.tr("Genres");
                    }
                }
                return this.propertyKey.toString();
            }
            case FILE_TYPE: {
                return I18n.tr("Types");
            }
        }
        throw new IllegalStateException("Unknown filter type " + (Object)((Object)this.filterType));
    }

    private EventList<Object> createPropertyList(EventList<E> resultsList) {
        switch (this.filterType) {
            case EXTENSION: 
            case PROPERTY: 
            case FILE_TYPE: {
                return GlazedListsFactory.simpleFunctionList(resultsList, new PropertyFunction(this.filterType, this.propertyKey));
            }
        }
        throw new IllegalArgumentException("Invalid filter type " + (Object)((Object)this.filterType));
    }

    private FilterList<Object> createNonNullList(EventList<Object> propertyList) {
        return GlazedListsFactory.filterList(propertyList, new Matcher<Object>(){

            @Override
            public boolean matches(Object item) {
                return item != null;
            }
        });
    }

    private FilterPopupPanel createMorePopup() {
        FilterPopupPanel popupPanel = new FilterPopupPanel(this.getResources(), this.getPropertyText());
        popupPanel.setListCellRenderer(new PropertyCellRenderer(popupPanel.getBackground(), BorderFactory.createEmptyBorder(1, 4, 0, 1)));
        DefaultEventListModel<Object> listModel = new DefaultEventListModel<Object>(this.uniqueList);
        this.popupSelectionModel = new DefaultEventSelectionModel<Object>(this.uniqueList);
        popupPanel.setListModel(listModel);
        popupPanel.setListSelectionModel(this.popupSelectionModel);
        this.popupSelectionModel.addListSelectionListener(new SelectionListener(this.popupSelectionModel));
        return popupPanel;
    }

    private void showMorePopup() {
        if (this.morePopupPanel == null) {
            this.morePopupPanel = this.createMorePopup();
        }
        this.morePopupPanel.showPopup(this.moreButton, this.list.getWidth() - 12, this.propertyLabel.getY() - this.moreButton.getY());
    }

    private void hideMorePopup() {
        if (this.morePopupPanel != null) {
            this.morePopupPanel.hidePopup();
        }
    }

    private class PropertyFunction
    implements FunctionList.Function<E, Object> {
        private final FilterType filterType;
        private final FilePropertyKey propertyKey;

        public PropertyFunction(FilterType filterType, FilePropertyKey propertyKey) {
            this.filterType = filterType;
            this.propertyKey = propertyKey;
        }

        @Override
        public Object evaluate(E item) {
            switch (this.filterType) {
                case EXTENSION: {
                    return item.getFileExtension().toLowerCase();
                }
                case PROPERTY: {
                    return item.getProperty(this.propertyKey);
                }
                case FILE_TYPE: {
                    return ((IconManager)PropertyFilter.this.iconManager.get()).getMIMEDescription(item.getFileExtension());
                }
            }
            return null;
        }
    }

    private static class PropertyComparator
    implements Comparator<Object> {
        private final FilterType filterType;
        private final FilePropertyKey propertyKey;

        public PropertyComparator(FilterType filterType, FilePropertyKey propertyKey) {
            this.filterType = filterType;
            this.propertyKey = propertyKey;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (this.filterType == FilterType.PROPERTY && FilePropertyKey.isLong(this.propertyKey)) {
                Long long1 = (Long)o1;
                Long long2 = (Long)o2;
                return Objects.compareToNull(long1, long2, false);
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            return Objects.compareToNullIgnoreCase(s1, s2, false);
        }
    }

    private class PropertyCountComparator
    implements Comparator<Object> {
        private PropertyCountComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int count2;
            int count1 = PropertyFilter.this.uniqueList.getCount(o1);
            return count1 < (count2 = PropertyFilter.this.uniqueList.getCount(o2)) ? 1 : (count1 > count2 ? -1 : 0);
        }
    }

    private class PropertyCellRenderer
    extends DefaultListCellRenderer {
        private final Color background;
        private final Border border;

        public PropertyCellRenderer(Color background, Border border) {
            this.background = background;
            this.border = border;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (renderer instanceof JLabel && value != null) {
                int count = PropertyFilter.this.uniqueList.getCount(value);
                StringBuilder buf = new StringBuilder();
                buf.append(value.toString()).append(" (").append(count).append(")");
                ((JLabel)renderer).setText(buf.toString());
                ((JLabel)renderer).setBackground(this.background);
                ((JLabel)renderer).setBorder(this.border);
            }
            return renderer;
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private final DefaultEventSelectionModel<Object> selectionModel;

        public SelectionListener(DefaultEventSelectionModel<Object> selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PropertyFilter.this.isActive()) {
                return;
            }
            EventList<Object> selectedList = this.selectionModel.getSelected();
            if (selectedList.size() > 0) {
                PropertyMatcher newMatcher = new PropertyMatcher(PropertyFilter.this.filterType, PropertyFilter.this.propertyKey, PropertyFilter.this.iconManager, selectedList);
                PropertyFilter.this.activate(selectedList.get(0).toString(), newMatcher);
            } else {
                PropertyFilter.this.deactivate();
            }
            PropertyFilter.this.hideMorePopup();
            PropertyFilter.this.fireFilterChanged(PropertyFilter.this);
        }
    }

    private class MoreAction
    extends AbstractAction {
        public MoreAction() {
            super(I18n.tr("more"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterInspectionUtils.moreFiltersClicked();
            if (PropertyFilter.this.morePopupPanel == null) {
                PropertyFilter.this.showMorePopup();
            } else if (PropertyFilter.this.morePopupPanel.isPopupReady()) {
                PropertyFilter.this.showMorePopup();
            } else {
                PropertyFilter.this.morePopupPanel.setPopupReady(true);
            }
        }
    }
}

