/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table.renderer;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.downloads.table.DownloadActionHandler;
import org.limewire.ui.swing.table.TableRendererEditor;
import org.limewire.ui.swing.transfer.TransferRendererResources;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.CommonUtils;

public class DownloadMessageRendererEditor
extends TableRendererEditor {
    @Resource
    private Icon infoIcon;
    private final DownloadActionHandler actionHandler;
    private final TransferRendererResources resources;
    private JLabel messageLabel;
    private JButton infoButton;
    private DownloadItem downloadItem;

    @Inject
    public DownloadMessageRendererEditor(DownloadActionHandler actionHandler) {
        this.actionHandler = actionHandler;
        this.resources = new TransferRendererResources();
        GuiUtils.assignResources(this);
        this.setLayout(new MigLayout("insets 0, gap 0, aligny center, nogrid, novisualpadding"));
        this.messageLabel = new JLabel();
        this.infoButton = new IconButton(this.infoIcon);
        this.infoButton.setActionCommand("info");
        this.infoButton.setToolTipText(I18n.tr("Info"));
        this.infoButton.addActionListener(new ButtonListener());
        this.add((Component)this.messageLabel, "");
        this.add((Component)this.infoButton, "");
    }

    @Override
    protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof DownloadItem) {
            this.downloadItem = (DownloadItem)value;
            this.update(this.downloadItem);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DownloadItem) {
            this.update((DownloadItem)value);
            return this;
        }
        return this.emptyPanel;
    }

    private void update(DownloadItem item) {
        DownloadState state = item.getState();
        this.resources.decorateComponent(this.messageLabel);
        this.messageLabel.setText(this.getPercentMessage(item) + this.getMessage(item));
        if (state == DownloadState.DANGEROUS || state == DownloadState.THREAT_FOUND || state == DownloadState.SCAN_FAILED || state == DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS) {
            this.messageLabel.setForeground(this.resources.getDisabledForeground());
        }
        this.infoButton.setVisible(item.getDownloadItemType() == DownloadItem.DownloadItemType.ANTIVIRUS || state == DownloadState.DANGEROUS || state == DownloadState.SCANNING || state == DownloadState.SCANNING_FRAGMENT || state == DownloadState.THREAT_FOUND || state == DownloadState.SCAN_FAILED || state == DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS);
    }

    private String getPercentMessage(DownloadItem item) {
        int percent = item.getPercentComplete();
        DownloadState state = item.getState();
        if (percent == 0 || state.isFinished() || state == DownloadState.DOWNLOADING || state == DownloadState.ERROR || state == DownloadState.SCANNING) {
            return "";
        }
        return percent + "% - ";
    }

    private String getMessage(DownloadItem item) {
        switch (item.getState()) {
            case RESUMING: {
                return I18n.tr("Resuming");
            }
            case CANCELLED: {
                return I18n.tr("Cancelled");
            }
            case FINISHING: {
                return I18n.tr("Finishing...");
            }
            case DONE: {
                return I18n.tr("Done");
            }
            case CONNECTING: {
                Collection<RemoteHost> hosts = item.getRemoteHosts();
                if (hosts.size() == 0) {
                    return I18n.tr("Connecting...");
                }
                return I18n.tr("Connecting to {0}", this.getPeopleText(item));
            }
            case DOWNLOADING: {
                if (item.getDownloadSourceCount() == 0) {
                    return I18n.tr("{0} of {1} ({2})", GuiUtils.formatUnitFromBytes(item.getCurrentSize()), GuiUtils.formatUnitFromBytes(item.getTotalSize()), GuiUtils.formatKilobytesPerSec(item.getDownloadSpeed()));
                }
                return I18n.tr("{0} of {1} ({2}) from {3}", GuiUtils.formatUnitFromBytes(item.getCurrentSize()), GuiUtils.formatUnitFromBytes(item.getTotalSize()), GuiUtils.formatKilobytesPerSec(item.getDownloadSpeed()), this.getPeopleText(item));
            }
            case TRYING_AGAIN: {
                return this.getTryAgainMessage(item.getRemainingTimeInState());
            }
            case STALLED: {
                if (item.getDownloadItemType() == DownloadItem.DownloadItemType.BITTORRENT) {
                    return I18n.tr("Error downloading torrent");
                }
                return I18n.tr("Stalled - {0} of {1}", GuiUtils.formatUnitFromBytes(item.getCurrentSize()), GuiUtils.formatUnitFromBytes(item.getTotalSize()));
            }
            case ERROR: {
                return I18n.tr("Unable to download: ") + I18n.tr(item.getErrorState().getMessage());
            }
            case PAUSED: {
                return I18n.tr("Paused - {0} of {1}", GuiUtils.formatUnitFromBytes(item.getCurrentSize()), GuiUtils.formatUnitFromBytes(item.getTotalSize()));
            }
            case LOCAL_QUEUED: {
                return this.getQueueTimeMessage(item.getRemainingTimeInState());
            }
            case REMOTE_QUEUED: {
                if (item.getRemoteQueuePosition() == -1 || item.getRemoteQueuePosition() == Integer.MAX_VALUE) {
                    return this.getQueueTimeMessage(item.getRemainingTimeInState());
                }
                return I18n.trn("Waiting - Next in line", "Waiting - {0} in line", item.getRemoteQueuePosition(), item.getRemoteQueuePosition());
            }
            case DANGEROUS: {
                return I18n.tr("File deleted - Dangerous file");
            }
            case SCANNING: {
                return I18n.tr("Scanning for viruses - Powered by AVG");
            }
            case SCANNING_FRAGMENT: {
                return I18n.tr("Scanning preview - Powered by AVG");
            }
            case THREAT_FOUND: {
                return I18n.tr("File deleted - Threat detected by AVG");
            }
            case SCAN_FAILED: 
            case SCAN_FAILED_DOWNLOADING_DEFINITIONS: {
                return I18n.tr("Done, but unable to scan for viruses");
            }
        }
        return null;
    }

    private String getTryAgainMessage(long tryingAgainTime) {
        if (tryingAgainTime == Long.MAX_VALUE) {
            return I18n.tr("Looking for file...");
        }
        return I18n.tr("Looking for file ({0} left)", CommonUtils.seconds2time(tryingAgainTime));
    }

    private String getPeopleText(DownloadItem item) {
        if (item.isStoreDownload()) {
            return I18n.tr("Store");
        }
        Collection<RemoteHost> hosts = item.getRemoteHosts();
        if (hosts.size() == 0) {
            int downloadSourceCount = item.getDownloadSourceCount();
            if (downloadSourceCount < 1) {
                return I18n.tr("nobody");
            }
            return I18n.trn("{0} P2P User", "{0} P2P Users", downloadSourceCount);
        }
        if (hosts.size() == 1) {
            Friend friend = hosts.iterator().next().getFriendPresence().getFriend();
            if (friend.isAnonymous()) {
                return I18n.tr("1 P2P User");
            }
            return friend.getRenderName();
        }
        boolean hasP2P = false;
        boolean hasFriend = false;
        for (RemoteHost host : hosts) {
            if (host.getFriendPresence().getFriend().isAnonymous()) {
                hasP2P = true;
            } else {
                hasFriend = true;
            }
            if (!hasP2P || !hasFriend) continue;
            break;
        }
        if (hasP2P && hasFriend) {
            return I18n.trn("{0} Person", "{0} People", hosts.size());
        }
        if (hasP2P) {
            return I18n.trn("{0} P2P User", "{0} P2P Users", hosts.size());
        }
        return I18n.trn("{0} Friend", "{0} Friends", hosts.size());
    }

    private String getQueueTimeMessage(long queueTime) {
        return I18n.tr("Waiting...");
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof IconButton) {
                ((IconButton)e.getSource()).resetDefaultCursor();
            }
            DownloadMessageRendererEditor.this.actionHandler.performAction(e.getActionCommand(), DownloadMessageRendererEditor.this.downloadItem);
            DownloadMessageRendererEditor.this.cancelCellEditing();
        }
    }
}

