/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLayeredPane;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.Resizable;

public abstract class OverlayPopupPanel
extends Panel
implements Resizable,
ComponentListener,
Disposable {
    protected final JLayeredPane layeredPane;
    private final Component childPanel;

    public OverlayPopupPanel(JLayeredPane layeredPane) {
        this(layeredPane, null);
    }

    public OverlayPopupPanel(JLayeredPane layeredPane, Component childPanel) {
        this.layeredPane = layeredPane;
        this.childPanel = childPanel;
        if (childPanel != null) {
            this.setLayout(new BorderLayout());
            this.add(childPanel, "Center");
            childPanel.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    OverlayPopupPanel.this.setVisible(false);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    OverlayPopupPanel.this.setVisible(true);
                }
            });
            if (!childPanel.isVisible()) {
                this.setVisible(false);
            }
        }
        layeredPane.add((Component)this, JLayeredPane.MODAL_LAYER);
        layeredPane.addComponentListener(this);
        this.resize();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.childPanel != null) {
            this.childPanel.setVisible(b);
        }
    }

    @Override
    public void dispose() {
        this.layeredPane.removeComponentListener(this);
        this.layeredPane.remove(this);
        if (this.childPanel instanceof Disposable) {
            ((Disposable)((Object)this.childPanel)).dispose();
        }
    }

    @Override
    public abstract void resize();

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.resize();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

