/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.limewire.ui.swing.components.ColoredBusyLabel;
import org.limewire.ui.swing.components.FancyTabProperties;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.SwingHacks;

public class FancyTab
extends JXPanel {
    private final TabActionMap tabActions;
    private final AbstractButton mainButton;
    private final AbstractButton removeButton;
    private final JLabel busyLabel;
    private final JLabel additionalText;
    private final FancyTabProperties props;
    private TabState currentState;
    private boolean mouseInside;
    private Icon removeEmptyIcon;
    @Resource
    private Icon removeActiveIcon;
    @Resource
    private Icon removeActiveRolloverIcon;
    @Resource
    private Icon removeActivePressedIcon;
    @Resource
    private Icon removeInactiveIcon;
    @Resource
    private Icon removeInactiveRolloverIcon;
    @Resource
    private Icon removeInactivePressedIcon;

    public FancyTab(TabActionMap actionMap, ButtonGroup group, FancyTabProperties fancyTabProperties) {
        GuiUtils.assignResources(this);
        this.removeEmptyIcon = new EmptyIcon(this.removeActiveIcon.getIconWidth(), this.removeActiveIcon.getIconHeight());
        this.tabActions = actionMap;
        this.props = fancyTabProperties;
        this.mainButton = this.createMainButton();
        this.additionalText = this.createAdditionalText();
        this.removeButton = this.createRemoveButton();
        this.busyLabel = this.createBusyLabel();
        if (group != null) {
            group.add(this.mainButton);
        }
        this.mainButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FancyTab.this.changeState(e.getStateChange() == 1 ? TabState.SELECTED : TabState.BACKGROUND);
            }
        });
        this.setOpaque(false);
        this.setToolTipText(this.getTooltip());
        HighlightListener highlightListener = new HighlightListener();
        if (this.props.isRemovable()) {
            this.removeButton.addMouseListener(highlightListener);
        }
        this.addMouseListener(highlightListener);
        this.mainButton.addMouseListener(highlightListener);
        this.updateButtons(false);
        this.changeState(this.isSelected() ? TabState.SELECTED : TabState.BACKGROUND);
        this.setLayout(new MigLayout("insets 0 0 0 0, fill, gap 0"));
        this.add((Component)this.mainButton, "gapafter 4, gapbefore 6, growy, aligny 50%, width min(pref,50):pref:max, cell 1 0");
        this.add((Component)this.additionalText, "gapafter 4, aligny 50%, cell 2 0, hidemode 3");
        this.add((Component)this.busyLabel, "gapbefore 4, gapafter 6, gapbottom 1, aligny 50%, alignx right, cell 3 0, hidemode 3");
        this.add((Component)this.removeButton, "gapbefore 4, gapafter 6, gapbottom 1, aligny 50%, alignx right, cell 3 0, hidemode 3");
    }

    @Override
    public String toString() {
        return "FancyTab for: " + this.getTitle() + ", " + super.toString();
    }

    @Override
    public Insets getInsets() {
        if (this.props == null || this.props.getInsets() == null) {
            return super.getInsets();
        }
        return this.props.getInsets();
    }

    private boolean isBusy() {
        return Boolean.TRUE.equals(this.tabActions.getMainAction().getValue("busy.indicator"));
    }

    JLabel createBusyLabel() {
        final ColoredBusyLabel busy = new ColoredBusyLabel(new Dimension(12, 12));
        busy.setVisible(false);
        if (this.isBusy()) {
            busy.setBusy(true);
            busy.setVisible(true);
        }
        this.tabActions.getMainAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("busy.indicator")) {
                    boolean on = Boolean.TRUE.equals(evt.getNewValue());
                    busy.setBusy(on);
                    busy.setVisible(on);
                    FancyTab.this.updateButtons(FancyTab.this.mouseInside);
                }
            }
        });
        return busy;
    }

    JLabel createAdditionalText() {
        final JLabel label = new JLabel();
        label.setVisible(false);
        if (this.tabActions.getMoreTextAction() != null) {
            label.setOpaque(false);
            label.setFont(this.mainButton.getFont());
            String name = (String)this.tabActions.getMoreTextAction().getValue("Name");
            if (name != null && name.length() > 0) {
                label.setText("(" + name + ")");
                label.setVisible(true);
            }
            this.tabActions.getMoreTextAction().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("Name")) {
                        if (evt.getNewValue() != null) {
                            String newValue = (String)evt.getNewValue();
                            label.setText("(" + newValue + ")");
                            label.setVisible(true);
                        } else {
                            label.setVisible(false);
                        }
                    }
                }
            });
        }
        return label;
    }

    JButton createRemoveButton() {
        JButton button = new JButton();
        button.setIcon(this.removeEmptyIcon);
        button.setRolloverIcon(this.removeActiveRolloverIcon);
        button.setPressedIcon(this.removeActivePressedIcon);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setRolloverEnabled(true);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setAction(this.tabActions.getRemoveAction());
        button.setActionCommand("tab.remove");
        button.setHideActionText(true);
        button.setVisible(false);
        if (this.removeButton != null) {
            for (ActionListener listener : this.removeButton.getActionListeners()) {
                if (listener == this.tabActions.getRemoveAction()) continue;
                button.addActionListener(listener);
            }
        }
        return button;
    }

    AbstractButton createMainButton() {
        final JToggleButton button = new JToggleButton();
        button.setModel(new NoToggleModel());
        button.setAction(this.tabActions.getMainAction());
        button.setActionCommand("tab.select");
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setToolTipText(this.getTooltip());
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        if (this.props.getTextFont() != null) {
            button.setFont(this.props.getTextFont());
        }
        if (Boolean.TRUE.equals(this.tabActions.getMainAction().getValue("new.indicator"))) {
            FontUtils.bold(button);
        } else {
            FontUtils.plain(button);
        }
        this.tabActions.getMainAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("new.indicator")) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        FontUtils.bold(button);
                    } else {
                        FontUtils.plain(button);
                    }
                }
            }
        });
        return button;
    }

    public FancyTabProperties getProperties() {
        return this.props;
    }

    public TabActionMap getTabActionMap() {
        return this.tabActions;
    }

    public void remove() {
        this.removeButton.doClick(0);
    }

    public void select() {
        this.mainButton.doClick(0);
    }

    void addRemoveActionListener(ActionListener listener) {
        this.removeButton.addActionListener(listener);
    }

    void removeRemoveActionListener(ActionListener listener) {
        this.removeButton.removeActionListener(listener);
    }

    void setSelected(boolean selected) {
        this.mainButton.setSelected(selected);
    }

    boolean isSelected() {
        return this.mainButton.isSelected();
    }

    void setButtonForeground(Color color) {
        this.mainButton.setForeground(color);
        this.additionalText.setForeground(color);
    }

    void setUnderlineEnabled(boolean enabled) {
        if (enabled) {
            FontUtils.underline(this.mainButton);
        } else {
            FontUtils.removeUnderline(this.mainButton);
        }
    }

    boolean isHighlighted() {
        return this.currentState == TabState.ROLLOVER;
    }

    void removeFromGroup(ButtonGroup group) {
        group.remove(this.mainButton);
    }

    public void setTextFont(Font font) {
        if (this.mainButton != null) {
            this.mainButton.setFont(font);
        }
        if (this.additionalText != null) {
            this.additionalText.setFont(font);
        }
    }

    private void updateButtons(boolean mouseInside) {
        this.mouseInside = mouseInside;
        if (mouseInside || !this.isBusy()) {
            if (this.props.isRemovable()) {
                this.removeButton.setVisible(true);
            } else {
                this.removeButton.setVisible(false);
            }
            this.busyLabel.setVisible(false);
        } else {
            this.busyLabel.setVisible(true);
            this.removeButton.setVisible(false);
        }
    }

    private void changeState(TabState tabState) {
        if (this.currentState != tabState) {
            this.currentState = tabState;
            switch (tabState) {
                case SELECTED: {
                    this.setUnderlineEnabled(false);
                    this.mainButton.setForeground(this.props.getSelectionColor());
                    this.additionalText.setForeground(this.props.getSelectionColor());
                    this.setBackgroundPainter(this.props.getSelectedPainter());
                    this.removeButton.setIcon(this.removeActiveIcon);
                    this.removeButton.setRolloverIcon(this.removeActiveRolloverIcon);
                    this.removeButton.setPressedIcon(this.removeActivePressedIcon);
                    break;
                }
                case BACKGROUND: {
                    this.setUnderlineEnabled(this.props.isUnderlineEnabled());
                    this.mainButton.setForeground(this.props.getNormalColor());
                    this.additionalText.setForeground(this.props.getNormalColor());
                    this.setBackgroundPainter(this.props.getNormalPainter());
                    this.removeButton.setIcon(this.removeEmptyIcon);
                    break;
                }
                case ROLLOVER: {
                    this.setUnderlineEnabled(this.props.isUnderlineEnabled());
                    this.setBackgroundPainter(this.props.getHighlightPainter());
                    this.removeButton.setIcon(this.removeInactiveIcon);
                    this.removeButton.setRolloverIcon(this.removeInactiveRolloverIcon);
                    this.removeButton.setPressedIcon(this.removeInactivePressedIcon);
                }
            }
        }
    }

    public String getTitle() {
        return (String)this.tabActions.getMainAction().getValue("Name");
    }

    private String getTooltip() {
        return (String)this.tabActions.getMainAction().getValue("LongDescription");
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        SwingHacks.fixPopupMenuForWindows(menu);
        for (Action action : this.getTabActionMap().getRightClickActions()) {
            if (action == TabActionMap.SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            menu.add(action);
        }
        if (this.getComponentCount() != 0 && this.props.isRemovable()) {
            menu.addSeparator();
        }
        if (this.props.isRemovable()) {
            menu.add(this.getTabActionMap().getRemoveOthers());
            menu.add(this.getTabActionMap().getRemoveAll());
            menu.addSeparator();
            menu.add(new AbstractAction(this.props.getCloseOneText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FancyTab.this.remove();
                }
            });
        }
        menu.show((Component)e.getSource(), e.getX() + 3, e.getY() + 3);
    }

    private static class NoToggleModel
    extends JToggleButton.ToggleButtonModel {
        private NoToggleModel() {
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed() && !this.isSelected()) {
                this.setSelected(true);
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }
    }

    private class HighlightListener
    extends MouseAdapter {
        private HighlightListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FancyTab.this.updateButtons(true);
            if (!FancyTab.this.isSelected() && FancyTab.this.mainButton.isEnabled()) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                FancyTab.this.changeState(TabState.ROLLOVER);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FancyTab.this.updateButtons(false);
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            if (!FancyTab.this.isSelected()) {
                FancyTab.this.changeState(TabState.BACKGROUND);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (FancyTab.this.props.isRemovable() && SwingUtilities.isMiddleMouseButton(e)) {
                FancyTab.this.remove();
            } else if (!(e.getSource() instanceof AbstractButton) && SwingUtilities.isLeftMouseButton(e)) {
                FancyTab.this.select();
            } else if (e.isPopupTrigger()) {
                FancyTab.this.showPopup(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                FancyTab.this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                FancyTab.this.showPopup(e);
            }
        }
    }

    private static enum TabState {
        BACKGROUND,
        ROLLOVER,
        SELECTED;

    }
}

