/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.FancyTabProperties;
import org.limewire.ui.swing.components.TabActionMap;

public abstract class AbstractTabList
extends JXPanel {
    private final List<FancyTab> tabs = new ArrayList<FancyTab>();
    private final ButtonGroup tabGroup = new ButtonGroup();
    private final FancyTabProperties props = new FancyTabProperties();

    protected AbstractTabList() {
    }

    public void setTabActionMaps(Iterable<? extends TabActionMap> newActionMaps) {
        for (FancyTab fancyTab : this.tabs) {
            fancyTab.removeFromGroup(this.tabGroup);
        }
        this.tabs.clear();
        for (TabActionMap tabActionMap : newActionMaps) {
            FancyTab tab = this.createAndPrepareTab(tabActionMap);
            this.tabs.add(tab);
        }
        this.layoutTabs();
    }

    protected FancyTab createAndPrepareTab(TabActionMap actionMap) {
        final FancyTab tab = new FancyTab(actionMap, this.tabGroup, this.props);
        tab.addRemoveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTabList.this.removeTab(tab);
            }
        });
        actionMap.getMainAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue().equals(Boolean.TRUE)) {
                    AbstractTabList.this.layoutTabs();
                }
            }
        });
        return tab;
    }

    protected abstract void layoutTabs();

    protected void addTab(FancyTab tab, int i) {
        this.tabs.add(i, tab);
        this.layoutTabs();
    }

    protected void removeTab(FancyTab tab) {
        boolean selected = tab.isSelected();
        int idx = this.tabs.indexOf(tab);
        assert (idx != -1);
        this.tabs.remove(tab);
        tab.removeFromGroup(this.tabGroup);
        if (selected && !this.tabs.isEmpty()) {
            if (idx == 0 && this.tabs.size() > 0) {
                this.tabs.get(0).getTabActionMap().getMainAction().putValue("SwingSelectedKey", true);
            } else if (idx > 0 && this.tabs.size() > 0) {
                this.tabs.get(idx - 1).getTabActionMap().getMainAction().putValue("SwingSelectedKey", true);
            }
        } else {
            this.layoutTabs();
        }
    }

    public void removeTabActionMap(TabActionMap actionMap) {
        Iterator<FancyTab> iter = this.tabs.iterator();
        while (iter.hasNext()) {
            FancyTab tab = iter.next();
            if (!tab.getTabActionMap().equals(actionMap)) continue;
            tab.removeFromGroup(this.tabGroup);
            iter.remove();
            break;
        }
        this.layoutTabs();
    }

    public FancyTab getSelectedTab() {
        for (FancyTab tab : this.tabs) {
            if (!tab.isSelected()) continue;
            return tab;
        }
        return null;
    }

    public FancyTabProperties getTabProperties() {
        return this.props;
    }

    public List<FancyTab> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    public void setHighlightPainter(Painter<?> highlightPainter) {
        for (FancyTab tab : this.tabs) {
            if (!tab.isHighlighted()) continue;
            tab.setBackgroundPainter(highlightPainter);
        }
        this.props.setHighlightPainter(highlightPainter);
    }

    public void setNormalPainter(Painter<?> normalPainter) {
        for (FancyTab tab : this.tabs) {
            if (tab.isHighlighted() || tab.isSelected()) continue;
            tab.setBackgroundPainter(normalPainter);
        }
        this.props.setNormalPainter(normalPainter);
    }

    public void setSelectionPainter(Painter<?> selectedPainter) {
        for (FancyTab tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.setBackgroundPainter(selectedPainter);
        }
        this.props.setSelectedPainter(selectedPainter);
    }

    public void setTabTextColor(Color normalColor) {
        for (FancyTab tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.setButtonForeground(normalColor);
        }
        this.props.setNormalColor(normalColor);
    }

    public void setTabTextSelectedColor(Color selectionColor) {
        for (FancyTab tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.setButtonForeground(selectionColor);
        }
        this.props.setSelectionColor(selectionColor);
    }

    public void setTextFont(Font font) {
        for (FancyTab tab : this.tabs) {
            tab.setTextFont(font);
        }
        this.props.setTextFont(font);
    }
}

