/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.animate;

import javax.swing.JWindow;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.animate.AbstractAnimator;
import org.limewire.ui.swing.animate.AnimatorEvent;
import org.limewire.ui.swing.util.WindowTransparencyUtils;

public class FadeOutAnimator
extends AbstractAnimator<JWindow> {
    public FadeOutAnimator(final JWindow window, int totalTime) {
        super(window, totalTime);
        this.addListener((EventListener)new EventListener<AnimatorEvent<JWindow>>(){

            @Override
            public void handleEvent(AnimatorEvent event) {
                if (event.getType() == AnimatorEvent.Type.STEP) {
                    int currentStep = event.getAnimator().getCurrentStepNumber();
                    float alpha = (float)(FadeOutAnimator.this.getTotalNumberOfSteps() - currentStep) / (float)FadeOutAnimator.this.getTotalNumberOfSteps();
                    WindowTransparencyUtils.setAlpha(window, alpha);
                } else if (event.getType() == AnimatorEvent.Type.STOPPED) {
                    window.setVisible(false);
                }
            }
        });
    }
}

