/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.table.TableColumnExt;
import org.limewire.core.api.connection.ConnectionItem;
import org.limewire.ui.swing.advanced.connection.ConnectionTableFormat;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.util.I18n;

public class ConnectionTable
extends MouseableTable {
    private TransformedList<ConnectionItem, ConnectionItem> connectionList;
    private ConnectionTableFormat tableFormat;
    private JMenuItem disabledMenuItem;
    private JPopupMenu headerPopup;
    private String[] tipArray;
    private Action defaultConfigAction = new DefaultConfigAction(I18n.tr("Revert To Default"));
    private Action autosortAction = new AutosortAction(I18n.tr("Sort Automatically"));
    private Action tooltipsAction = new TooltipsAction(I18n.tr("Extended Tooltips"));
    private Action toggleColumnAction = new ToggleColumnAction();

    public ConnectionTable() {
        this.setIntercellSpacing(new Dimension(1, 0));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setShowHorizontalLines(false);
        this.getTableHeader().setToolTipText(I18n.tr("Right-click to select columns to display"));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ConnectionTable.this.showHeaderPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ConnectionTable.this.showHeaderPopup(e);
                }
            }
        });
    }

    @Override
    protected void setTableHeaderRenderer() {
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setDefaultRenderer((Class)Object.class, (TableCellRenderer)new ObjectCellRenderer());
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip toolTip = new MultiLineToolTip();
        toolTip.setComponent(this);
        toolTip.setToolTipArray(this.tipArray);
        return toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (Boolean.TRUE.equals(this.tooltipsAction.getValue("SwingSelectedKey")) && row >= 0) {
            ConnectionItem item = this.connectionList.get(this.convertRowIndexToModel(row));
            this.tipArray = this.tableFormat.getToolTipArray(item);
            return row + "," + col;
        }
        this.tipArray = new String[0];
        return null;
    }

    @Override
    protected boolean shouldSortOnChange(TableModelEvent e) {
        if (this.autosortAction == null || Boolean.TRUE.equals(this.autosortAction.getValue("SwingSelectedKey"))) {
            return super.shouldSortOnChange(e);
        }
        return false;
    }

    public void setColumnVisible(String name, boolean visible) {
        TableColumnExt column = this.getColumnExt(name);
        column.setVisible(visible);
        String columnTitle = column.getTitle();
        AbstractButton matchingItem = null;
        int itemCount = this.headerPopup.getComponentCount();
        for (int i = 0; i < itemCount; ++i) {
            JCheckBoxMenuItem item;
            String itemTitle;
            Component menuComponent = this.headerPopup.getComponent(i);
            if (!(menuComponent instanceof JCheckBoxMenuItem) || !(itemTitle = (item = (JCheckBoxMenuItem)menuComponent).getText()).equals(columnTitle)) continue;
            matchingItem = item;
            break;
        }
        if (matchingItem != null) {
            matchingItem.setSelected(visible);
        }
    }

    public void setColumnWidth(String name, int width) {
        this.getColumnExt(name).setPreferredWidth(width);
    }

    public void setEventList(TransformedList<ConnectionItem, ConnectionItem> connectionList, ConnectionTableFormat tableFormat) {
        if (tableFormat == null) {
            throw new IllegalArgumentException("tableFormat cannot be null");
        }
        this.connectionList = connectionList;
        this.tableFormat = tableFormat;
        this.setModel(new DefaultEventTableModel<ConnectionItem>(connectionList, tableFormat));
        this.headerPopup = this.createHeaderPopup();
        this.resetTableColumns();
    }

    public void clearEventList() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof DefaultEventTableModel) {
            ((DefaultEventTableModel)tableModel).dispose();
        }
        this.setModel(new DefaultTableModel());
        this.connectionList.dispose();
        this.connectionList = null;
    }

    public ConnectionItem[] getSelectedConnections() {
        int[] rows = this.getSelectedRows();
        ConnectionItem[] items = new ConnectionItem[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            items[i] = this.connectionList.get(this.convertRowIndexToModel(rows[i]));
        }
        return items;
    }

    public void refresh() {
        TableModel model = this.getModel();
        if (model instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    public void resetTableColumns() {
        for (int col = 0; col < this.tableFormat.getColumnCount(); ++col) {
            ConnectionTableFormat.ConnectionColumn column = this.tableFormat.getColumn(col);
            this.setColumnWidth(column.getName(), column.getWidth());
            this.setColumnVisible(column.getName(), column.isVisible());
        }
        this.autosortAction.putValue("SwingSelectedKey", Boolean.TRUE);
        this.tooltipsAction.putValue("SwingSelectedKey", Boolean.FALSE);
    }

    private JPopupMenu createHeaderPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem defaultItem = new JMenuItem();
        defaultItem.setAction(this.defaultConfigAction);
        popupMenu.add(defaultItem);
        JMenu optionsMenu = new JMenu(I18n.tr("More Options"));
        popupMenu.add(optionsMenu);
        popupMenu.addSeparator();
        JCheckBoxMenuItem autosortItem = new JCheckBoxMenuItem();
        autosortItem.setAction(this.autosortAction);
        optionsMenu.add(autosortItem);
        JCheckBoxMenuItem tooltipsItem = new JCheckBoxMenuItem();
        tooltipsItem.setAction(this.tooltipsAction);
        optionsMenu.add(tooltipsItem);
        int columnCount = this.tableFormat.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String headerName = this.tableFormat.getColumnName(i);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(headerName, true);
            item.addActionListener(this.toggleColumnAction);
            popupMenu.add(item);
        }
        return popupMenu;
    }

    private void showHeaderPopup(MouseEvent e) {
        if (this.headerPopup != null) {
            this.headerPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private void updateHeaderPopup() {
        int visibleColumnCount = this.getColumnCount(false);
        if (visibleColumnCount == 1) {
            Component[] components;
            int allColumnCount = this.getColumnCount(true);
            TableColumnExt column = null;
            for (int i = 0; i < allColumnCount && !(column = this.getColumnExt(i)).isVisible(); ++i) {
            }
            assert (column != null);
            String headerName = column.getTitle();
            for (Component component : components = this.headerPopup.getComponents()) {
                JMenuItem item;
                if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getText().equals(headerName)) continue;
                item.setEnabled(false);
                this.disabledMenuItem = item;
                break;
            }
        } else if (this.disabledMenuItem != null) {
            this.disabledMenuItem.setEnabled(true);
        }
    }

    private static class MultiLineToolTip
    extends JToolTip {
        private static final int LINE_LEN = 72;
        private String[] tipArray;

        private MultiLineToolTip() {
        }

        @Override
        public String getTipText() {
            if (this.tipArray != null && this.tipArray.length > 0) {
                StringBuilder buf = new StringBuilder("<html>");
                boolean firstLine = true;
                for (String text : this.tipArray) {
                    while (text.length() > 72) {
                        buf.append(firstLine ? "" : "<br/>");
                        buf.append(text.substring(0, 72));
                        firstLine = false;
                        text = text.substring(72);
                    }
                    buf.append(firstLine ? "" : "<br/>");
                    buf.append(text);
                    firstLine = false;
                }
                buf.append("</html>");
                return buf.toString();
            }
            return null;
        }

        public void setToolTipArray(String[] tipArray) {
            this.tipArray = tipArray;
        }
    }

    private static class ObjectCellRenderer
    extends DefaultTableRenderer {
        private ObjectCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (renderer instanceof JLabel) {
                ((JLabel)renderer).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return renderer;
        }
    }

    private class ToggleColumnAction
    extends AbstractAction {
        private ToggleColumnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableColumnExt selectedColumn;
            String name = e.getActionCommand();
            boolean visible = (selectedColumn = ConnectionTable.this.getColumnExt(name)).isVisible();
            selectedColumn.setVisible(!visible);
            ConnectionTable.this.updateHeaderPopup();
            ConnectionTable.this.packAll();
        }
    }

    private static class TooltipsAction
    extends AbstractAction {
        public TooltipsAction(String name) {
            super(name);
            this.putValue("SwingSelectedKey", Boolean.FALSE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class AutosortAction
    extends AbstractAction {
        public AutosortAction(String name) {
            super(name);
            this.putValue("SwingSelectedKey", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class DefaultConfigAction
    extends AbstractAction {
        public DefaultConfigAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConnectionTable.this.resetTableColumns();
        }
    }
}

