/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Stage;
import com.limegroup.gnutella.ActiveLimeWireCheck;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.connection.ConnectionInspections;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.LogUtils;
import com.sun.jna.Native;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.application.Application;
import org.limewire.core.api.malware.VirusEngine;
import org.limewire.core.impl.mozilla.LimeMozillaOverrides;
import org.limewire.core.settings.InstallSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inject.GuiceUtils;
import org.limewire.io.IOUtils;
import org.limewire.net.FirewallService;
import org.limewire.nio.NIODispatcher;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.ui.support.BugManager;
import org.limewire.ui.support.DeadlockSupport;
import org.limewire.ui.support.ErrorHandler;
import org.limewire.ui.support.FatalBugManager;
import org.limewire.ui.swing.DefaultErrorCatcher;
import org.limewire.ui.swing.GURLHandler;
import org.limewire.ui.swing.LimeWireModule;
import org.limewire.ui.swing.MacEventHandler;
import org.limewire.ui.swing.Main;
import org.limewire.ui.swing.MessageHandler;
import org.limewire.ui.swing.SettingsWarningManager;
import org.limewire.ui.swing.UncaughtExceptionHandlerImpl;
import org.limewire.ui.swing.browser.LimeMozillaInitializer;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.SplashWindow;
import org.limewire.ui.swing.mainframe.AppFrame;
import org.limewire.ui.swing.settings.StartupSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.LocaleUtils;
import org.limewire.ui.swing.util.MacOSXUtils;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.ui.swing.util.WindowsUtils;
import org.limewire.ui.swing.wizard.IntentDialog;
import org.limewire.util.CommonUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;
import org.limewire.util.Stopwatch;
import org.limewire.util.SystemUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.mozilla.browser.MozillaPanel;

final class Initializer {
    private final Log LOG;
    private final long EXPIRATION_DATE = Long.MAX_VALUE;
    private long startMemory;
    private final Stopwatch stopwatch;
    private final AtomicReference<SplashWindow> splashRef = new AtomicReference();
    @Inject
    private Provider<ExternalControl> externalControl;
    @Inject
    private Provider<FirewallService> firewallServices;
    @Inject
    private Provider<LifecycleManager> lifecycleManager;
    @Inject
    private Provider<LimeCoreGlue> limeCoreGlue;
    @Inject
    private Provider<NIODispatcher> nioDispatcher;
    @Inject
    private Provider<LimeMozillaOverrides> mozillaOverrides;
    @Inject
    private Provider<ConnectionInspections> connectionReporter;
    @Inject
    private Provider<VirusEngine> virusEngine;

    Initializer() {
        if (LogUtils.isLog4JAvailable()) {
            System.getProperties().remove("org.apache.commons.logging.Log");
        }
        this.LOG = LogFactory.getLog(Initializer.class);
        if (this.LOG.isTraceEnabled()) {
            this.startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.LOG.trace("START Initializer, using: " + this.startMemory + " memory");
        }
        this.stopwatch = new Stopwatch(this.LOG);
    }

    void initialize(String[] args, Frame awtSplash, Image splashImage) throws Throwable {
        this.preinit();
        this.setupCallbacksAndListeners();
        this.validateStartup(args);
        Injector injector = this.createLimeWire();
        this.glueCore();
        this.validateEarlyCore();
        this.runExternalChecks(args, injector);
        DeadlockSupport.startDeadlockMonitoring();
        this.stopwatch.resetAndLog("Start deadlock monitor");
        this.installProperties();
        this.confirmIntent(awtSplash);
        this.switchSplashes(awtSplash, splashImage, LimeWireUtils.isPro());
        this.startEarlyCore();
        this.initializeEarlyUI();
        this.loadUI();
        this.enableNativeMenuItemsAndEventHandlers();
        SettingsWarningManager.checkTemporaryDirectoryUsage();
        SettingsWarningManager.checkSettingsLoadSaveFailure();
        this.startCore();
        this.runQueuedRequests();
        this.ensureStartupSettingsConfigured();
        this.postinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void confirmIntent(final Frame awtSplash) {
        File versionFile = new File(CommonUtils.getUserSettingsDir(), "versions.props");
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(versionFile);
            properties.load(inputStream);
        }
        catch (IOException iox) {
            IOUtils.close(inputStream);
            catch (Throwable throwable) {
                IOUtils.close(inputStream);
                throw throwable;
            }
        }
        IOUtils.close(inputStream);
        this.updateVersionsUsed(properties);
        String exists = properties.getProperty(LimeWireUtils.getLimeWireVersion());
        if (exists == null || !exists.equals("true")) {
            SwingUtils.invokeNowOrWait(new Runnable(){

                @Override
                public void run() {
                    if (awtSplash != null) {
                        awtSplash.setVisible(false);
                    }
                    SharingSettings.WARN_SHARING_DOCUMENTS_WITH_WORLD.setValue(true);
                    boolean confirmed = new IntentDialog(LimeWireUtils.getLimeWireVersion(), (VirusEngine)Initializer.this.virusEngine.get()).confirmLegal();
                    if (!confirmed) {
                        System.exit(0);
                    }
                    if (awtSplash != null) {
                        awtSplash.setVisible(true);
                    }
                }
            });
            properties.put(LimeWireUtils.getLimeWireVersion(), "true");
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(versionFile);
                properties.store(outputStream, "Started & Ran Versions");
            }
            catch (IOException ignored) {
                IOUtils.close(outputStream);
                catch (Throwable throwable) {
                    IOUtils.close(outputStream);
                    throw throwable;
                }
            }
            IOUtils.close(outputStream);
        }
    }

    private void updateVersionsUsed(Properties properties) {
        for (Object key : properties.keySet()) {
            String versionString = key.toString();
            try {
                Version version = new Version(versionString);
                InstallSettings.PREVIOUS_RAN_VERSIONS.add(version.getVersion());
            }
            catch (VersionFormatException e) {}
        }
    }

    private void preinit() {
        try {
            LimeCoreGlue.preinstall();
            this.stopwatch.resetAndLog("Preinstall");
        }
        catch (LimeCoreGlue.InstallFailedException ife) {
            GuiUtils.hideAndDisposeAllWindows();
            this.failPreferencesPermissions();
        }
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                String name = UIManager.getSystemLookAndFeelClassName();
                if (OSUtils.isLinux()) {
                    name = UIManager.getCrossPlatformLookAndFeelClassName();
                }
                try {
                    UIManager.setLookAndFeel(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private void setupCallbacksAndListeners() {
        final AtomicReference bugManager = new AtomicReference();
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                bugManager.set(new BugManager());
            }
        });
        ErrorService.setErrorCallback(new ErrorHandler((BugManager)bugManager.get()));
        UncaughtExceptionHandlerImpl uncaughtHandler = new UncaughtExceptionHandlerImpl();
        Thread.setDefaultUncaughtExceptionHandler(uncaughtHandler);
        Native.setCallbackExceptionHandler(uncaughtHandler);
        this.stopwatch.resetAndLog("ErrorHandler install");
        MessageService.setCallback(new MessageHandler());
        this.stopwatch.resetAndLog("MessageHandler install");
        DefaultErrorCatcher.install();
        this.stopwatch.resetAndLog("DefaultErrorCatcher install");
        if (OSUtils.isMacOSX()) {
            SystemUtils.setOpenFileLimit(1024);
            this.stopwatch.resetAndLog("Open file limit raise");
            MacEventHandler.instance();
            this.stopwatch.resetAndLog("MacEventHandler instance");
        }
    }

    private void validateStartup(String[] args) {
        if (System.currentTimeMillis() > Long.MAX_VALUE) {
            GuiUtils.hideAndDisposeAllWindows();
            this.failExpired();
        }
        if (StartupSettings.RUN_ON_STARTUP.getValue()) {
            this.stopwatch.reset();
            Thread.yield();
            this.stopwatch.resetAndLog("Thread yield");
        }
        if (args.length >= 1 && "-startup".equals(args[0])) {
            LimeWireUtils.setAutoStartupLaunch(true);
        }
        if (LimeWireUtils.isAutoStartupLaunch()) {
            args = null;
            if (!StartupSettings.RUN_ON_STARTUP.getValue()) {
                System.exit(0);
            }
        }
        if (!StartupSettings.ALLOW_MULTIPLE_INSTANCES.getValue()) {
            block9: {
                ActiveLimeWireCheck activeCheck = ActiveLimeWireCheck.instance();
                this.stopwatch.resetAndLog("Create ActiveLimeWireCheck");
                try {
                    if (activeCheck.checkForActiveLimeWire(args)) {
                        System.exit(0);
                    }
                }
                catch (ActiveLimeWireCheck.ActiveLimeWireException e) {
                    this.LOG.debug(e);
                    this.stopwatch.resetAndLog("Warn user about running instance");
                    GuiUtils.hideAndDisposeAllWindows();
                    if (this.warnAlreadyRunning()) break block9;
                    System.exit(0);
                }
            }
            this.stopwatch.resetAndLog("Run ActiveLimeWireCheck");
        }
    }

    private Injector createLimeWire() {
        this.stopwatch.reset();
        Injector injector = Guice.createInjector(Stage.DEVELOPMENT, new LimeWireModule(), new AbstractModule(){

            @Override
            protected void configure() {
                this.requestStaticInjection(AppFrame.class);
                this.requestInjection(Initializer.this);
            }
        });
        GuiceUtils.loadEagerSingletons(injector);
        this.stopwatch.resetAndLog("Create injector");
        return injector;
    }

    private void glueCore() {
        this.limeCoreGlue.get().install();
        this.stopwatch.resetAndLog("Install core glue");
    }

    private void validateEarlyCore() {
        if (!this.nioDispatcher.get().isRunning()) {
            GuiUtils.hideAndDisposeAllWindows();
            this.failInternetBlocked();
        }
        this.stopwatch.resetAndLog("Check for NIO dispatcher");
    }

    private void runExternalChecks(String[] args, Injector injector) {
        this.stopwatch.resetAndLog("Get externalControl");
        if (OSUtils.isMacOSX()) {
            GURLHandler.getInstance().enable(this.externalControl.get());
            this.stopwatch.resetAndLog("Enable GURL");
            injector.injectMembers((Object)MacEventHandler.instance());
            this.stopwatch.resetAndLog("Enable macEventHandler");
        }
        if (args.length > 0 && !args[0].equals("-startup")) {
            String arg = ExternalControl.preprocessArgs(args);
            this.stopwatch.resetAndLog("Preprocess args");
            this.externalControl.get().enqueueControlRequest(arg);
            this.stopwatch.resetAndLog("Enqueue control req");
        }
    }

    private void installProperties() {
        System.setProperty("http.agent", LimeWireUtils.getHttpServer());
        this.stopwatch.resetAndLog("set system properties");
        if (OSUtils.isMacOSX()) {
            System.setProperty("user.fullname", MacOSXUtils.getUserName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.stopwatch.resetAndLog("set OSX properties");
        }
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                LocaleUtils.setLocaleFromPreferences();
                LocaleUtils.validateLocaleAndFonts();
            }
        });
        this.stopwatch.resetAndLog("set locale");
    }

    private void ensureStartupSettingsConfigured() {
        if (OSUtils.isWindows() && StartupSettings.RUN_ON_STARTUP.getValue()) {
            WindowsUtils.setLoginStatus(true);
        }
    }

    private void startEarlyCore() {
        boolean inFirewallException = this.firewallServices.get().addToFirewall();
        this.stopwatch.resetAndLog("add firewall exception");
        if (!inFirewallException) {
            this.lifecycleManager.get().loadBackgroundTasks();
            this.stopwatch.resetAndLog("load background tasks");
        }
    }

    private void switchSplashes(Frame awtSplash, final Image splashImage, final boolean isPro) {
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                Initializer.this.splashRef.set(new SplashWindow(splashImage, isPro, LocaleUtils.getCurrentLocale(), 4));
                if (!LimeWireUtils.isAutoStartupLaunch()) {
                    ((SplashWindow)Initializer.this.splashRef.get()).begin();
                    Initializer.this.stopwatch.resetAndLog("begin splash window");
                }
            }
        });
        if (awtSplash != null) {
            awtSplash.dispose();
            this.stopwatch.resetAndLog("dispose AWT splash");
        }
    }

    private void initializeEarlyUI() {
        this.splashRef.get().setStatusText(I18n.tr("Muddling Mint..."));
        this.stopwatch.resetAndLog("update splash for HTML engine");
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                Initializer.this.stopwatch.resetAndLog("enter evt queue");
                JLabel label = new JLabel();
                label.setFont(null);
                label.setForeground(null);
                BasicHTML.createHTMLView(label, "<html>.</html>");
                Initializer.this.stopwatch.resetAndLog("create HTML view");
            }
        });
        this.stopwatch.resetAndLog("return from evt queue");
        this.splashRef.get().setStatusText(I18n.tr("Scouring NYC for Limes..."));
        if (LimeMozillaInitializer.shouldInitialize()) {
            Locale locale = Locale.getDefault();
            if (locale.getLanguage().equals("tr")) {
                Locale.setDefault(Locale.ENGLISH);
            }
            try {
                LimeMozillaInitializer.initialize();
                this.mozillaOverrides.get().overrideMozillaDefaults();
            }
            catch (Exception e) {
                Locale.setDefault(locale);
                this.LOG.error("Mozilla initialization failed");
            }
            this.stopwatch.resetAndLog("Load XUL Library Path");
            SwingUtils.invokeNowOrWait(new Runnable(){

                @Override
                public void run() {
                    Initializer.this.stopwatch.resetAndLog("enter evt queue");
                    new MozillaPanel();
                    Initializer.this.stopwatch.resetAndLog("Load MozillaPanel");
                }
            });
        }
        this.stopwatch.resetAndLog("return from evt queue");
    }

    private void loadUI() {
        String[] stringArray;
        this.splashRef.get().setStatusText(I18n.tr("Squeezing Limes..."));
        this.stopwatch.resetAndLog("update splash for UI");
        DefaultErrorCatcher.storeCaughtBugs();
        if (LimeWireUtils.isAutoStartupLaunch()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "startup";
        } else {
            stringArray = new String[]{};
        }
        String[] launchParams = stringArray;
        Application.launch(AppFrame.class, launchParams);
        this.loadLateTasksForUI();
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                ((SplashWindow)Initializer.this.splashRef.get()).dispose();
                Initializer.this.splashRef.set(null);
                List<Throwable> caughtBugs = DefaultErrorCatcher.getAndResetStoredBugs();
                if (!AppFrame.isStarted()) {
                    assert (caughtBugs.size() > 0);
                    FatalBugManager.handleFatalBug(caughtBugs.get(caughtBugs.size() - 1));
                } else {
                    for (Throwable throwable : caughtBugs) {
                        ErrorService.error(throwable, "Startup Error");
                    }
                }
                ((ConnectionInspections)Initializer.this.connectionReporter.get()).setLoadTime(System.currentTimeMillis() - Main.getStartTime());
            }
        });
    }

    private void enableNativeMenuItemsAndEventHandlers() {
        if (OSUtils.isMacOSX()) {
            MacEventHandler.instance().enableAllMacMenusAndEventHandlers();
        }
    }

    private void loadLateTasksForUI() {
        this.splashRef.get().setStatusText(I18n.tr("Prepping Mojitos..."));
        I18NConvert.instance();
        this.stopwatch.resetAndLog("I18nConvert instance");
    }

    private void startCore() {
        this.lifecycleManager.get().start();
        this.stopwatch.resetAndLog("lifecycle manager start");
    }

    private void runQueuedRequests() {
        this.externalControl.get().runQueuedControlRequest();
        this.stopwatch.resetAndLog("run queued control req");
    }

    private void postinit() {
        if (this.LOG.isTraceEnabled()) {
            long stopMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            this.LOG.trace("STOP Initializer, using: " + stopMemory + " memory, consumed: " + (stopMemory - this.startMemory));
        }
    }

    private void failExpired() {
        this.fail(I18n.tr("This Alpha version has expired.  Press Ok to exit. "));
    }

    private void failInternetBlocked() {
        this.fail(I18n.tr("LimeWire was unable to initialize and start. This is usually due to a security program blocking LimeWire's access to the internet or loopback connections on the local machine. Please add LimeWire as an exception to your security software and restart LimeWire.."));
    }

    private void failPreferencesPermissions() {
        this.fail(I18n.tr("LimeWire could not create a temporary preferences folder.\n\nThis is generally caused by a lack of permissions.  Please make sure that LimeWire (and you) have access to create files/folders on your computer.  If the problem persists, please visit www.limewire.com and click the 'Support' link.\n\nLimeWire will now exit.  Thank You."));
    }

    private void fail(final String msgKey) {
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, new MultiLineLabel(msgKey, 300), I18n.tr("Error"), 0);
            }
        });
        System.exit(1);
    }

    private boolean warnAlreadyRunning() {
        final AtomicInteger response = new AtomicInteger(2);
        final String message = I18n.tr("Another instance of LimeWire appears to be running. Please completely shut down all other instances of LimeWire before continuing. If this problem persists, please restart your computer.");
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                response.set(JOptionPane.showConfirmDialog(null, new MultiLineLabel(message, 300), I18n.tr("LimeWire is already running"), 2));
            }
        });
        return response.get() == 0;
    }
}

