/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;
import org.limewire.util.FileUtils;

public class FileArraySetting
extends AbstractSetting<File[]> {
    private File[] value;

    FileArraySetting(Properties defaultProps, Properties props, String key, File[] defaultValue) {
        super(defaultProps, props, key, FileArraySetting.decode(defaultValue));
        this.setPrivate(true);
    }

    @Override
    public File[] get() {
        return this.value;
    }

    @Override
    public synchronized void set(File[] value) {
        this.setValueInternal(FileArraySetting.decode(value));
    }

    public synchronized void add(File file) {
        if (file == null) {
            return;
        }
        File[] newValue = new File[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = file;
        this.set(newValue);
    }

    public synchronized boolean remove(File file) {
        if (file == null) {
            return false;
        }
        int index = this.indexOf(file);
        if (index == -1) {
            return false;
        }
        File[] newValue = new File[this.value.length - 1];
        System.arraycopy(this.value, 0, newValue, 0, index);
        System.arraycopy(this.value, index + 1, newValue, index, this.value.length - index - 1);
        this.set(newValue);
        return true;
    }

    public synchronized boolean contains(File file) {
        return this.indexOf(file) >= 0;
    }

    public synchronized int indexOf(File file) {
        if (file == null) {
            return -1;
        }
        for (int i = 0; i < this.value.length; ++i) {
            try {
                if (!FileUtils.getCanonicalFile(this.value[i]).equals(FileUtils.getCanonicalFile(file))) continue;
                return i;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return -1;
    }

    public synchronized int length() {
        return this.value.length;
    }

    @Override
    protected synchronized void loadValue(String sValue) {
        this.value = FileArraySetting.encode(sValue);
    }

    private static File[] encode(String src) {
        if (src == null || src.length() == 0) {
            return new File[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        File[] dirs = new File[tokenizer.countTokens()];
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i] = new File(tokenizer.nextToken());
        }
        return dirs;
    }

    private static String decode(File[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (File file : src) {
            buffer.append(file.getAbsolutePath()).append(';');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public synchronized void clean() {
        ArrayList<File> list = new ArrayList<File>(this.value.length);
        for (File aValue : this.value) {
            File file = aValue;
            if (file == null || !file.exists()) continue;
            list.add(file);
        }
        this.set(list.toArray(new File[list.size()]));
    }
}

