/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSocket;
import org.limewire.rudp.UDPSocketChannel;

class UDPConnection
extends AbstractNBSocket
implements RUDPSocket {
    private final UDPSocketChannel channel;
    private int soTimeout = 60000;
    private final RUDPContext context;

    UDPConnection(RUDPContext context, UDPSocketChannel channel) {
        this.context = context;
        this.channel = channel;
        this.setInitialReader();
        this.setInitialWriter();
    }

    @Override
    protected InterestReadableByteChannel getBaseReadChannel() {
        return this.channel;
    }

    @Override
    protected InterestWritableByteChannel getBaseWriteChannel() {
        return this.channel;
    }

    @Override
    protected void shutdownImpl() {
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.context.getUDPService().getStableListeningAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.channel.getRemoteSocketAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getAddress();
    }

    @Override
    public int getPort() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getPort();
    }

    @Override
    public int getLocalPort() {
        return this.context.getUDPService().getStableListeningPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public String toString() {
        return "UDPConnection:" + this.channel;
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return !this.channel.isOpen();
    }

    @Override
    public boolean isOutputShutdown() {
        return !this.channel.isOpen();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
    }

    @Override
    public int getSoLinger() throws SocketException {
        return -1;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return 10240;
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return 81920;
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int getTrafficClass() throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }
}

