/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Set;
import org.limewire.promotion.DatabaseExecutionException;
import org.limewire.promotion.PromotionBinder;
import org.limewire.promotion.PromotionBinderRepository;
import org.limewire.promotion.PromotionBinderRequestor;
import org.limewire.promotion.PromotionServices;
import org.limewire.promotion.SearcherDatabase;
import org.limewire.promotion.impressions.ImpressionsCollector;
import org.limewire.promotion.impressions.UserQueryEvent;

@Singleton
public class PromotionBinderRepositoryImpl
implements PromotionBinderRepository {
    private final PromotionBinderRequestor requestor;
    private final ImpressionsCollector impressionsCollector;
    private final SearcherDatabase searcherDatabase;
    private final PromotionServices promotionServices;
    private Provider<String> searchUrl;
    private Provider<Integer> modulus;

    @Inject
    public PromotionBinderRepositoryImpl(PromotionBinderRequestor requestor, ImpressionsCollector impressionsCollector, SearcherDatabase searcherDatabase, PromotionServices promotionServices) {
        this.requestor = requestor;
        this.impressionsCollector = impressionsCollector;
        this.searcherDatabase = searcherDatabase;
        this.promotionServices = promotionServices;
    }

    @Override
    public PromotionBinder getBinderForBucket(long bucketNumber) {
        int bucket = (int)(bucketNumber % (long)this.modulus.get().intValue());
        try {
            this.searcherDatabase.expungeExpired();
        }
        catch (DatabaseExecutionException e) {
            this.promotionServices.stop();
            return null;
        }
        PromotionBinder binder = this.searcherDatabase.getBinder(bucket);
        if (binder != null) {
            return binder;
        }
        return this.getBinderForBucketOnNetwork(bucket);
    }

    @Override
    public void init(Provider<String> url, Provider<Integer> modulus) {
        this.searchUrl = url;
        this.modulus = modulus;
    }

    private PromotionBinder getBinderForBucketOnNetwork(long bucketNumber) {
        Set<UserQueryEvent> queries = this.impressionsCollector.getCollectedImpressions();
        String url = this.searchUrl.get();
        url = url + "?now=" + System.currentTimeMillis() / 1000L;
        PromotionBinder result = this.requestor.request(url, bucketNumber, queries);
        this.impressionsCollector.removeImpressions(queries);
        return result;
    }
}

