/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.util.BufferUtils;

public class ReadSkipState
extends ReadState {
    private final AtomicLong leftToRead;

    public ReadSkipState(long length) {
        this(new AtomicLong(length));
    }

    public ReadSkipState(AtomicLong length) {
        this.leftToRead = length;
    }

    @Override
    protected boolean processRead(ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
        this.leftToRead.set(BufferUtils.delete(buffer, this.leftToRead.get()));
        int read = 0;
        while (this.leftToRead.get() > 0L && (read = rc.read(buffer)) > 0) {
            this.leftToRead.set(BufferUtils.delete(buffer, this.leftToRead.get()));
        }
        if (this.leftToRead.get() > 0L && read == -1) {
            throw new IOException("EOF");
        }
        return this.leftToRead.get() > 0L;
    }

    @Override
    public long getAmountProcessed() {
        return -1L;
    }
}

