/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.manager.BootstrapProcess;
import org.limewire.mojito.result.FindNodeResult;

class BootstrapWorker
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BootstrapWorker.class);
    private final BootstrapProcess process;
    private final Context context;
    private volatile OnewayExchanger<FindNodeResult, ExecutionException> exchanger;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    BootstrapWorker(Context context, BootstrapProcess process) {
        this.process = process;
        this.context = context;
    }

    @Override
    public void run() {
        LOG.debug("starting worker");
        while (!this.shutdown.get()) {
            KUID nextBucket = this.process.getNextBucket();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " will refresh " + nextBucket);
            }
            if (nextBucket == null) {
                return;
            }
            this.refreshBucket(nextBucket);
        }
    }

    private void refreshBucket(KUID randomId) {
        OnewayExchanger c = new OnewayExchanger(true);
        FindNodeResponseHandler handler = new FindNodeResponseHandler(this.context, randomId);
        handler.start(c);
        this.exchanger = c;
        FindNodeResult value = null;
        try {
            value = (FindNodeResult)c.get();
        }
        catch (InterruptedException ignore) {
        }
        catch (CancellationException cancelled) {
            if (!this.shutdown.get()) {
                throw new IllegalStateException(cancelled);
            }
        }
        catch (ExecutionException ee) {
            LOG.info("ExecutionException", ee);
            this.process.handleExecutionException(ee);
        }
        if (value == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finished Bucket refresh: " + value);
        }
        this.process.refreshDone(value.getRouteTableFailureCount(), !value.getPath().isEmpty());
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        OnewayExchanger<FindNodeResult, ExecutionException> e = this.exchanger;
        if (e != null) {
            e.cancel();
        }
    }
}

