/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface IpPort {
    public static final Comparator<IpPort> IP_COMPARATOR = new IpComparator();
    public static final Comparator<IpPort> COMPARATOR = new IpPortComparator();
    public static final List<IpPort> EMPTY_LIST = Collections.emptyList();
    public static final Set<IpPort> EMPTY_SET = Collections.emptySet();

    public InetAddress getInetAddress();

    public int getPort();

    public String getAddress();

    public InetSocketAddress getInetSocketAddress();

    public static class IpPortComparator
    implements Comparator<IpPort> {
        @Override
        public int compare(IpPort ip1, IpPort ip2) {
            if (ip1 == ip2) {
                return 0;
            }
            if (ip1.getPort() != ip2.getPort()) {
                return ip1.getPort() - ip2.getPort();
            }
            return IP_COMPARATOR.compare(ip1, ip2);
        }
    }

    public static class IpComparator
    implements Comparator<IpPort> {
        @Override
        public int compare(IpPort ip1, IpPort ip2) {
            byte[] netb;
            if (ip1 == ip2) {
                return 0;
            }
            byte[] neta = ip1.getInetAddress().getAddress();
            if (neta[0] == (netb = ip2.getInetAddress().getAddress())[0]) {
                if (neta[1] == netb[1]) {
                    if (neta[2] == netb[2]) {
                        if (neta[3] == netb[3]) {
                            return 0;
                        }
                        return neta[3] - netb[3];
                    }
                    return neta[2] - netb[2];
                }
                return neta[1] - netb[1];
            }
            return neta[0] - netb[0];
        }
    }
}

