/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import org.limewire.util.ByteUtils;

public class IP {
    private static final String MSG = "Could not parse: ";
    public final int addr;
    public final int mask;

    public IP(byte[] b, int offset) throws IllegalArgumentException {
        if (b.length < offset + 4) {
            throw new IllegalArgumentException(MSG);
        }
        this.addr = IP.bytesToInt(b, offset);
        this.mask = -1;
    }

    public IP(int address, int mask) {
        this.addr = address;
        this.mask = mask;
    }

    public IP(byte[] ip_bytes) throws IllegalArgumentException {
        this(ip_bytes, 0);
        if (ip_bytes.length != 4) {
            throw new IllegalArgumentException(MSG);
        }
    }

    public IP(String ip_str) throws IllegalArgumentException {
        int slash = ip_str.indexOf(47);
        if (slash == -1) {
            this.mask = IP.createNetmaskFromWildChars(ip_str);
            this.addr = IP.stringToInt(ip_str);
        } else if (ip_str.lastIndexOf(47) == slash) {
            this.mask = IP.parseNetmask(ip_str.substring(slash + 1));
            this.addr = IP.stringToInt(ip_str.substring(0, slash)) & this.mask;
        } else {
            throw new IllegalArgumentException(MSG + ip_str);
        }
    }

    private static int parseNetmask(String mask) throws IllegalArgumentException {
        if (mask.indexOf(46) != -1) {
            return IP.stringToInt(mask);
        }
        try {
            int k = Integer.parseInt(mask);
            if (k >= 0 && k <= 32) {
                return k == 32 ? -1 : ~(-1 >>> k);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException(MSG + mask);
    }

    private static int bytesToInt(byte[] ip_bytes, int offset) {
        return ByteUtils.beb2int(ip_bytes, offset);
    }

    private static int stringToInt(String ip_str) throws IllegalArgumentException {
        int ip = 0;
        int numOctets = 0;
        int length = ip_str.length();
        int i = 0;
        while (i < length) {
            int octet = 0;
            int j = 0;
            while (i < length) {
                block10: {
                    block9: {
                        char c;
                        block8: {
                            c = ip_str.charAt(i);
                            if (c != '.') break block8;
                            if (j != 0 && numOctets < 3) {
                                break;
                            }
                            break block9;
                        }
                        if (c == '*' ? j == 0 : c >= '0' && c <= '9' && j <= 2 && (octet = octet * 10 + c - 48) <= 255) break block10;
                    }
                    throw new IllegalArgumentException(MSG + ip_str);
                }
                ++i;
                ++j;
            }
            ip = ip << 8 | octet;
            ++i;
            ++numOctets;
        }
        if (numOctets < 4) {
            ip <<= (4 - numOctets) * 8;
        }
        return ip;
    }

    private static int createNetmaskFromWildChars(String ip_str) throws IllegalArgumentException {
        int mask = 0;
        int numOctets = 0;
        int length = ip_str.length();
        int i = 0;
        while (i < length) {
            int submask = 255;
            int j = 0;
            while (i < length) {
                block11: {
                    block9: {
                        char c;
                        block10: {
                            block8: {
                                c = ip_str.charAt(i);
                                if (c != '.') break block8;
                                if (j != 0 && numOctets < 3) {
                                    break;
                                }
                                break block9;
                            }
                            if (c != '*') break block10;
                            if (j != 0) break block9;
                            submask = 0;
                            break block11;
                        }
                        if (c >= '0' && c <= '9' && j <= 2) break block11;
                    }
                    throw new IllegalArgumentException(MSG + ip_str);
                }
                ++i;
                ++j;
            }
            mask = mask << 8 | submask;
            ++i;
            ++numOctets;
        }
        if (numOctets < 4) {
            mask <<= (4 - numOctets) * 8;
        }
        return mask;
    }

    public int getDistanceTo(IP ip) {
        return (ip.addr ^ this.addr) & ip.mask & this.mask;
    }

    public String toString() {
        return this.toString(this.addr) + "/" + this.toString(this.mask);
    }

    private String toString(int i) {
        return (i >> 24 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i & 0xFF);
    }

    public boolean contains(IP ip) {
        return (ip.addr & this.mask) == this.addr && (ip.mask & this.mask) == this.mask;
    }

    public boolean equals(Object other) {
        if (other instanceof IP) {
            IP ip = (IP)other;
            return this.mask == ip.mask && (this.addr & this.mask) == (ip.addr & ip.mask);
        }
        return false;
    }

    public int hashCode() {
        return this.addr ^ this.mask;
    }
}

