/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.handler;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.entity.BasicFileTransferMonitor;
import org.limewire.http.entity.FileNIOEntity;
import org.limewire.http.entity.NotFoundEntity;
import org.limewire.http.handler.MimeTypeProvider;

public class FileRequestHandler
extends SimpleNHttpRequestHandler {
    private String indexFilename = "index.html";
    private final File rootDirectory;
    private final MimeTypeProvider mimeTypeProvider;
    private int timeout = -1;

    public FileRequestHandler(File rootDirectory, MimeTypeProvider mimeTypeProvider) {
        this.rootDirectory = rootDirectory;
        this.mimeTypeProvider = mimeTypeProvider;
    }

    public void setIndexFilename(String indexFilename) {
        this.indexFilename = indexFilename;
    }

    public String getIndexFilename() {
        return this.indexFilename;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws HttpException, IOException {
        return null;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        File file = this.getFile(request);
        if (file.exists() && file.isFile()) {
            String mimeType = this.mimeTypeProvider.getMimeType(file);
            FileNIOEntity entity = new FileNIOEntity(file, mimeType, new BasicFileTransferMonitor(context));
            if (this.timeout != -1) {
                entity.setTimeout(this.timeout);
            }
            response.setEntity(entity);
        } else {
            response.setEntity(new NotFoundEntity(request));
            response.setStatusCode(404);
        }
    }

    private File getFile(HttpRequest request) throws HttpException {
        if (!request.getRequestLine().getUri().startsWith("/")) {
            throw new ProtocolException("Invalid request");
        }
        File file = this.rootDirectory;
        StringTokenizer t = new StringTokenizer(request.getRequestLine().getUri(), "/");
        while (t.hasMoreTokens()) {
            String next = t.nextToken();
            if (next.indexOf(File.pathSeparator) != -1) {
                throw new ProtocolException("Invalid request");
            }
            if (next.indexOf("..") != -1) {
                throw new ProtocolException("Invalid request");
            }
            file = new File(file, next);
        }
        if (file.isDirectory()) {
            file = new File(file, this.indexFilename);
        }
        return file;
    }
}

