/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.entity;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.http.entity.Piece;
import org.limewire.http.entity.PieceListener;
import org.limewire.http.entity.PieceReader;
import org.limewire.nio.ByteBufferCache;

public class FilePieceReader
implements PieceReader {
    private static final Log LOG = LogFactory.getLog(FilePieceReader.class);
    private static final int THREAD_COUNT = 2;
    private static final int MAX_BUFFERS = 4;
    static int BUFFER_SIZE = 4096;
    private final List<ByteBuffer> bufferPool = new LinkedList<ByteBuffer>();
    private final Queue<Piece> pieceQueue = new PriorityQueue<Piece>(4);
    private static final ExecutorService QUEUE = ExecutorsHelper.newFixedSizeThreadPool(2, "DiskPieceReader");
    private final File file;
    private final PieceListener listener;
    private volatile FileChannel channel;
    private volatile RandomAccessFile raf;
    private final Object bufferPoolLock = new Object();
    private final ByteBufferCache bufferCache;
    private int bufferInUseCount;
    private volatile long readOffset;
    private long processingOffset;
    private long remaining;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final AtomicInteger jobCount = new AtomicInteger();

    public FilePieceReader(ByteBufferCache bufferCache, File file, long offset, long length, PieceListener listener) {
        if (bufferCache == null || file == null || listener == null) {
            throw new IllegalArgumentException();
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        if (length <= 0L) {
            throw new IllegalArgumentException("length must be > 0");
        }
        this.bufferCache = bufferCache;
        this.file = file;
        this.readOffset = offset;
        this.processingOffset = offset;
        this.remaining = length;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(long offset, ByteBuffer buffer) {
        if (this.shutdown.get()) {
            this.release(buffer);
            return;
        }
        assert (offset >= this.readOffset);
        Piece piece = new Piece(offset, buffer);
        FilePieceReader filePieceReader = this;
        synchronized (filePieceReader) {
            this.pieceQueue.add(piece);
        }
        if (offset == this.readOffset) {
            this.listener.readSuccessful();
        } else if (LOG.isDebugEnabled()) {
            filePieceReader = this;
            synchronized (filePieceReader) {
                LOG.debug("offset, readOffset: " + offset + ", " + this.readOffset);
            }
        }
    }

    protected void failed(IOException exception) {
        this.shutdown();
        this.listener.readFailed(exception);
    }

    public File getFile() {
        return this.file;
    }

    public synchronized boolean hasNext() throws EOFException {
        if (this.shutdown.get()) {
            throw new EOFException();
        }
        if (this.pieceQueue.isEmpty()) {
            return false;
        }
        return this.pieceQueue.peek().getOffset() == this.readOffset;
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Piece next() throws EOFException {
        if (this.shutdown.get()) {
            throw new EOFException();
        }
        Object object = this.bufferPoolLock;
        synchronized (object) {
            if (this.remaining == 0L && this.readOffset == this.processingOffset) {
                throw new EOFException();
            }
        }
        Piece piece = this.pieceQueue.peek();
        if (piece != null && piece.getOffset() == this.readOffset) {
            this.pieceQueue.remove();
            this.readOffset += (long)piece.getBuffer().remaining();
            return piece;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(ByteBuffer buffer) {
        Object object = this.bufferPoolLock;
        synchronized (object) {
            if (this.shutdown.get()) {
                this.bufferCache.release(buffer);
                return;
            }
            this.bufferPool.add(buffer);
            --this.bufferInUseCount;
            this.spawnJobs();
        }
    }

    @Override
    public void release(Piece piece) {
        this.release(piece.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return false;
        }
        Object object = this.bufferPoolLock;
        synchronized (object) {
            for (ByteBuffer buffer : this.bufferPool) {
                this.release(buffer);
            }
        }
        object = this;
        synchronized (object) {
            for (Piece piece : this.pieceQueue) {
                this.release(piece);
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing channel for file: " + this.file, e);
                }
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing file: " + this.file, e);
                }
            }
        }
        return true;
    }

    public void shutdownAndWait(long timeout) throws InterruptedException, TimeoutException {
        this.shutdown();
        this.waitForShutdown(timeout);
    }

    protected void waitForShutdown(long timeout) throws InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        while (this.jobCount.get() > 0) {
            long remainingTime = timeout - (System.currentTimeMillis() - start);
            if (remainingTime <= 0L) {
                throw new TimeoutException();
            }
            Thread.sleep(50L);
        }
    }

    public void start() {
        if (this.shutdown.get()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < 4 && (i == 0 || (long)(i * BUFFER_SIZE + 1) <= this.remaining); ++i) {
            this.bufferPool.add(this.bufferCache.getHeap(BUFFER_SIZE));
        }
        this.spawnJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnJobs() {
        Object object = this.bufferPoolLock;
        synchronized (object) {
            while (!this.shutdown.get() && this.remaining > 0L && this.bufferInUseCount < 4) {
                int length = (int)Math.min((long)BUFFER_SIZE, this.remaining);
                ByteBuffer buffer = this.bufferPool.remove(0);
                ++this.bufferInUseCount;
                PieceReaderJob job = new PieceReaderJob(buffer, this.processingOffset, length);
                this.processingOffset += (long)length;
                this.remaining -= (long)length;
                this.jobCount.incrementAndGet();
                QUEUE.execute(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChannel() throws IOException {
        if (this.channel != null) {
            return;
        }
        FilePieceReader filePieceReader = this;
        synchronized (filePieceReader) {
            if (this.channel != null) {
                return;
            }
            this.raf = new RandomAccessFile(this.file, "r");
            this.channel = this.raf.getChannel();
        }
    }

    private class PieceReaderJob
    implements Runnable {
        private final ByteBuffer buffer;
        private final long offset;
        private final int length;

        public PieceReaderJob(ByteBuffer buffer, long offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    if (FilePieceReader.this.shutdown.get()) {
                        FilePieceReader.this.release(this.buffer);
                        return;
                    }
                    this.buffer.clear();
                    this.buffer.limit(this.length);
                    IOException exception = null;
                    try {
                        FilePieceReader.this.initChannel();
                        while (this.buffer.hasRemaining()) {
                            int read = FilePieceReader.this.channel.read(this.buffer, this.offset + (long)this.buffer.position());
                            if (read != -1 && (read != 0 || FilePieceReader.this.raf.length() > this.offset + (long)this.buffer.position())) continue;
                            throw new EOFException("Attempt to read beyond end of file");
                        }
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    if (exception != null) {
                        try {
                            FilePieceReader.this.failed(exception);
                            break block13;
                        }
                        finally {
                            FilePieceReader.this.release(this.buffer);
                        }
                    }
                    this.buffer.flip();
                    assert (this.buffer.remaining() == this.length);
                    FilePieceReader.this.add(this.offset, this.buffer);
                }
                finally {
                    FilePieceReader.this.jobCount.decrementAndGet();
                }
            }
        }
    }
}

