/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.nio.protocol.NHttpRequestHandlerRegistry;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.limewire.http.HttpAcceptorListener;
import org.limewire.http.auth.AuthenticationInterceptor;
import org.limewire.http.protocol.ExtendedAsyncNHttpServiceHandler;
import org.limewire.http.protocol.HttpServiceEventListener;
import org.limewire.http.protocol.LimeResponseConnControl;
import org.limewire.http.protocol.SynchronizedHttpProcessor;
import org.limewire.http.protocol.SynchronizedNHttpRequestHandlerRegistry;
import org.limewire.http.reactor.DefaultDispatchedIOReactor;
import org.limewire.http.reactor.DispatchedIOReactor;
import org.limewire.lifecycle.Service;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.nio.NIODispatcher;
import org.limewire.service.ErrorService;

public abstract class BasicHttpAcceptor
implements ConnectionAcceptor,
Service {
    private static final Log LOG = LogFactory.getLog(BasicHttpAcceptor.class);
    public static final String[] DEFAULT_METHODS = new String[]{"GET", "HEAD", "POST"};
    private final AuthenticationInterceptor authenticationInterceptor;
    private final String[] supportedMethods;
    private final NHttpRequestHandlerRegistry registry;
    private final SynchronizedHttpProcessor processor;
    private final List<HttpAcceptorListener> acceptorListeners = new CopyOnWriteArrayList<HttpAcceptorListener>();
    private final HttpParams params;
    private DispatchedIOReactor reactor;
    private ConnectionEventListener connectionListener;
    private DefaultHttpResponseFactory responseFactory;
    private AtomicBoolean started = new AtomicBoolean();

    public BasicHttpAcceptor(HttpParams params, AuthenticationInterceptor authenticationInterceptor, String ... supportedMethods) {
        this.params = params;
        this.authenticationInterceptor = authenticationInterceptor;
        this.supportedMethods = supportedMethods;
        this.registry = new SynchronizedNHttpRequestHandlerRegistry();
        this.processor = new SynchronizedHttpProcessor();
        this.initializeDefaultInterceptors();
    }

    private void initializeDefaultInterceptors() {
        this.addRequestInterceptor(this.authenticationInterceptor);
        this.addResponseInterceptor(new ResponseDate());
        this.addResponseInterceptor(new ResponseServer());
        this.addResponseInterceptor(new ResponseContent());
        this.addResponseInterceptor(new LimeResponseConnControl());
    }

    public static HttpParams createDefaultParams(String userAgent, int timeout) {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", timeout);
        params.setIntParameter("http.connection.timeout", timeout);
        params.setIntParameter("http.socket.buffer-size", 8192);
        params.setBooleanParameter("http.tcp.nodelay", true);
        params.setParameter("http.origin-server", userAgent);
        params.setIntParameter("http.connection.max-line-length", 4096);
        params.setIntParameter("http.connection.max-header-count", 50);
        params.setParameter("http.protocol.element-charset", "ISO-8859-1");
        return params;
    }

    private void initializeReactor() {
        assert (NIODispatcher.instance().isDispatchThread());
        this.connectionListener = new ConnectionEventListener();
        this.responseFactory = new DefaultHttpResponseFactory();
        ExtendedAsyncNHttpServiceHandler serviceHandler = new ExtendedAsyncNHttpServiceHandler((HttpProcessor)this.processor, this.responseFactory, new DefaultConnectionReuseStrategy(), this.params);
        serviceHandler.setEventListener(this.connectionListener);
        serviceHandler.setHandlerResolver(this.registry);
        this.reactor = new DefaultDispatchedIOReactor(this.params, NIODispatcher.instance().getScheduledExecutorService());
        DefaultServerIOEventDispatch ioEventDispatch = new DefaultServerIOEventDispatch(serviceHandler, this.params);
        try {
            this.reactor.execute(ioEventDispatch);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public void acceptConnection(String word, Socket socket) {
        this.reactor.acceptConnection(word + " ", socket);
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    public String[] getHttpMethods() {
        return this.supportedMethods;
    }

    public void addAcceptorListener(HttpAcceptorListener listener) {
        this.acceptorListeners.add(listener);
    }

    public void addRequestInterceptor(HttpRequestInterceptor interceptor) {
        this.processor.addInterceptor(interceptor);
    }

    public void addResponseInterceptor(HttpResponseInterceptor interceptor) {
        this.processor.addInterceptor(interceptor);
    }

    protected DispatchedIOReactor getReactor() {
        assert (NIODispatcher.instance().isDispatchThread());
        return this.reactor;
    }

    public void removeAcceptorListener(HttpAcceptorListener listener) {
        this.acceptorListeners.remove(listener);
    }

    public void removeRequestInterceptor(HttpRequestInterceptor interceptor) {
        this.processor.removeInterceptor(interceptor);
    }

    public void removeResponseInterceptor(HttpResponseInterceptor interceptor) {
        this.processor.removeInterceptor(interceptor);
    }

    public void registerHandler(String pattern, NHttpRequestHandler handler) {
        this.registry.register(pattern, this.authenticationInterceptor.getGuardedHandler(pattern, handler));
    }

    public void unregisterHandler(String pattern) {
        this.authenticationInterceptor.unregisterHandler(pattern);
        this.registry.unregister(pattern);
    }

    @Override
    public void start() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException();
        }
        final AtomicBoolean inited = new AtomicBoolean(false);
        try {
            Future<?> result = NIODispatcher.instance().getScheduledExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    BasicHttpAcceptor.this.initializeReactor();
                    inited.set(true);
                }
            });
            result.get();
        }
        catch (InterruptedException e) {
            if (inited.get()) {
                LOG.warn("Interrupted while waiting for reactor initialization", e);
            } else {
                ErrorService.error(e);
            }
        }
        catch (ExecutionException e) {
            ErrorService.error(e);
        }
    }

    @Override
    public void stop() {
        if (!this.started.getAndSet(false)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getServiceName() {
        return null;
    }

    private class ConnectionEventListener
    implements HttpServiceEventListener {
        private ConnectionEventListener() {
        }

        @Override
        public void connectionOpen(NHttpConnection conn) {
            assert (NIODispatcher.instance().isDispatchThread());
            for (HttpAcceptorListener listener : BasicHttpAcceptor.this.acceptorListeners) {
                listener.connectionOpen(conn);
            }
        }

        @Override
        public void connectionClosed(NHttpConnection conn) {
            assert (NIODispatcher.instance().isDispatchThread());
            for (HttpAcceptorListener listener : BasicHttpAcceptor.this.acceptorListeners) {
                listener.connectionClosed(conn);
            }
        }

        @Override
        public void connectionTimeout(NHttpConnection conn) {
            throw new RuntimeException();
        }

        @Override
        public void fatalIOException(IOException e, NHttpConnection conn) {
            assert (NIODispatcher.instance().isDispatchThread());
            LOG.debug("HTTP connection error", e);
            for (HttpAcceptorListener listener : BasicHttpAcceptor.this.acceptorListeners) {
                listener.connectionClosed(conn);
            }
        }

        @Override
        public void fatalProtocolException(HttpException e, NHttpConnection conn) {
            assert (NIODispatcher.instance().isDispatchThread());
            LOG.debug("HTTP protocol error", e);
            for (HttpAcceptorListener listener : BasicHttpAcceptor.this.acceptorListeners) {
                listener.connectionClosed(conn);
            }
        }

        @Override
        public void responseSent(NHttpConnection conn, HttpResponse response) {
            assert (NIODispatcher.instance().isDispatchThread());
            for (HttpAcceptorListener listener : BasicHttpAcceptor.this.acceptorListeners) {
                listener.responseSent(conn, response);
            }
        }
    }
}

