/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.support;

import com.google.inject.Inject;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.connection.ConnectionCheckerManager;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.support.SessionInfo;
import org.limewire.net.SocketsManager;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.NIODispatcher;

class LimeSessionInfo
implements SessionInfo {
    private final NIODispatcher dispatcher;
    private final DownloadManager downloadManager;
    private final Statistics statistics;
    private final ConnectionManager connectionManager;
    private final ContentManager contentManager;
    private final CreationTimeCache creationTimeCache;
    private final DiskController diskController;
    private final SocketsManager socketsManager;
    private final ByteBufferCache byteBufferCache;
    private final UDPService udpService;
    private final Acceptor acceptor;
    private final DownloadServices downloadServices;
    private final UploadServices uploadServices;
    private final ConnectionCheckerManager connectionCheckerManager;
    private final NIODispatcher nioDispatcher;
    private final Library library;
    private final FileView gnutellaFileView;
    private final SimppManager simppManager;
    private final UploadSlotManager uploadSlotManager;
    private final ConnectionServices connectionServices;
    private final LifecycleManager lifecycleManager;
    private final RemoteLibraryManager remoteLibraryManager;
    private final NetworkManager networkManager;

    @Inject
    public LimeSessionInfo(NIODispatcher dispatcher, DownloadManager downloadManager, Statistics statistics, ConnectionManager connectionManager, ContentManager contentManager, CreationTimeCache creationTimeCache, DiskController diskController, SocketsManager socketsManager, ByteBufferCache byteBufferCache, UDPService udpService, Acceptor acceptor, DownloadServices downloadServices, UploadServices uploadServices, ConnectionCheckerManager connectionCheckerManager, NIODispatcher nioDispatcher, Library library, SimppManager simppManager, UploadSlotManager uploadSlotManager, ConnectionServices connectionServices, LifecycleManager lifecycleManager, RemoteLibraryManager remoteLibraryManager, @GnutellaFiles FileView gnutellaFileView, NetworkManager networkManager) {
        this.dispatcher = dispatcher;
        this.downloadManager = downloadManager;
        this.statistics = statistics;
        this.connectionManager = connectionManager;
        this.contentManager = contentManager;
        this.creationTimeCache = creationTimeCache;
        this.diskController = diskController;
        this.socketsManager = socketsManager;
        this.byteBufferCache = byteBufferCache;
        this.udpService = udpService;
        this.acceptor = acceptor;
        this.downloadServices = downloadServices;
        this.uploadServices = uploadServices;
        this.connectionCheckerManager = connectionCheckerManager;
        this.nioDispatcher = nioDispatcher;
        this.library = library;
        this.simppManager = simppManager;
        this.uploadSlotManager = uploadSlotManager;
        this.connectionServices = connectionServices;
        this.lifecycleManager = lifecycleManager;
        this.remoteLibraryManager = remoteLibraryManager;
        this.gnutellaFileView = gnutellaFileView;
        this.networkManager = networkManager;
    }

    @Override
    public int getNumberOfPendingTimeouts() {
        return this.dispatcher.getNumPendingTimeouts();
    }

    @Override
    public int getNumWaitingDownloads() {
        return this.downloadManager.getNumWaitingDownloads();
    }

    @Override
    public int getNumIndividualDownloaders() {
        return this.downloadManager.getNumIndividualDownloaders();
    }

    @Override
    public long getCurrentUptime() {
        return this.statistics.getUptime();
    }

    @Override
    public int getNumUltrapeerToLeafConnections() {
        return this.connectionManager.getNumInitializedClientConnections();
    }

    @Override
    public int getNumLeafToUltrapeerConnections() {
        return this.connectionManager.getNumClientSupernodeConnections();
    }

    @Override
    public int getNumUltrapeerToUltrapeerConnections() {
        return this.connectionManager.getNumUltrapeerConnections();
    }

    @Override
    public int getNumOldConnections() {
        return this.connectionManager.getNumOldConnections();
    }

    @Override
    public long getContentResponsesSize() {
        return this.contentManager.getCacheSize();
    }

    @Override
    public long getCreationCacheSize() {
        return this.creationTimeCache.getSize();
    }

    @Override
    public long getDiskControllerByteCacheSize() {
        return this.diskController.getSizeOfByteCache();
    }

    @Override
    public long getDiskControllerVerifyingCacheSize() {
        return this.diskController.getSizeOfVerifyingCache();
    }

    @Override
    public int getDiskControllerQueueSize() {
        return this.diskController.getNumPendingItems();
    }

    @Override
    public long getByteBufferCacheSize() {
        return this.byteBufferCache.getHeapCacheSize();
    }

    @Override
    public int getNumberOfWaitingSockets() {
        return this.socketsManager.getNumWaitingSockets();
    }

    @Override
    public boolean isGUESSCapable() {
        return this.networkManager.isGUESSCapable();
    }

    @Override
    public boolean canReceiveSolicited() {
        return this.networkManager.canReceiveSolicited();
    }

    @Override
    public boolean acceptedIncomingConnection() {
        return this.acceptor.acceptedIncoming();
    }

    @Override
    public int getPort() {
        return this.acceptor.getPort(true);
    }

    @Override
    public boolean canDoFWT() {
        return this.networkManager.canDoFWT();
    }

    @Override
    public int getNumActiveDownloads() {
        return this.downloadServices.getNumActiveDownloads();
    }

    @Override
    public int getNumActiveUploads() {
        return this.uploadServices.getNumUploads();
    }

    @Override
    public int getNumConnectionCheckerWorkarounds() {
        return this.connectionCheckerManager.getNumWorkarounds();
    }

    @Override
    public int getNumQueuedUploads() {
        return this.uploadServices.getNumQueuedUploads();
    }

    @Override
    public long[] getSelectStats() {
        return this.nioDispatcher.getSelectStats();
    }

    @Override
    public int getSharedFileListSize() {
        return this.gnutellaFileView.size();
    }

    @Override
    public int getManagedFileListSize() {
        return this.library.size();
    }

    @Override
    public int getAllFriendsFileListSize() {
        return this.remoteLibraryManager.getAllFriendsLibrary().size();
    }

    @Override
    public int getSimppVersion() {
        return this.simppManager.getVersion();
    }

    @Override
    public String getUploadSlotManagerInfo() {
        return this.uploadSlotManager.toString();
    }

    @Override
    public boolean isConnected() {
        return this.connectionServices.isConnected();
    }

    @Override
    public boolean isLifecycleLoaded() {
        return this.lifecycleManager.isLoaded();
    }

    @Override
    public boolean isShieldedLeaf() {
        return this.connectionServices.isShieldedLeaf();
    }

    @Override
    public boolean isSupernode() {
        return this.connectionServices.isSupernode();
    }

    @Override
    public boolean isUdpPortStable() {
        return this.udpService.portStable();
    }

    @Override
    public int lastReportedUdpPort() {
        return this.udpService.lastReportedPort();
    }

    @Override
    public int receivedIpPong() {
        return this.udpService.receivedIpPong();
    }
}

