/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.api.download;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.download.DownloadSourceInfo;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.Address;

public interface DownloadItem
extends PropertiableFile {
    public static final String DOWNLOAD_ITEM = "limewire.download.glueItem";
    public static final String DOWNLOAD_START_DATE = "limewire.download.startDate";
    public static final long UNKNOWN_TIME = Long.MAX_VALUE;

    public DownloadItemType getDownloadItemType();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public DownloadState getState();

    public String getTitle();

    public int getPercentComplete();

    public long getCurrentSize();

    public long getAmountVerified();

    public long getTotalSize();

    public long getAmountLost();

    public long getRemainingDownloadTime();

    public long getRemainingTimeInState();

    public void cancel();

    public void pause();

    public void resume();

    public int getDownloadSourceCount();

    public List<Address> getSources();

    public List<DownloadSourceInfo> getSourcesDetails();

    public DownloadPiecesInfo getPiecesInfo();

    @Override
    public Category getCategory();

    public float getDownloadSpeed();

    public Collection<RemoteHost> getRemoteHosts();

    public int getRemoteQueuePosition();

    public ErrorState getErrorState();

    public int getLocalQueuePriority();

    public boolean isLaunchable();

    public File getDownloadingFile();

    public File getLaunchableFile();

    public void setSaveFile(File var1, boolean var2) throws DownloadException;

    public File getSaveFile();

    public boolean isTryAgainEnabled();

    public Date getStartDate();

    public boolean isStoreDownload();

    public boolean isRelocatable();

    public Collection<File> getCompleteFiles();

    public Object getDownloadProperty(DownloadPropertyKey var1);

    public static enum ErrorState {
        DISK_PROBLEM(I18nMarker.marktr("There is a disk problem")),
        CORRUPT_FILE(I18nMarker.marktr("The file is corrupted")),
        INVALID(I18nMarker.marktr("The file is invalid")),
        UNABLE_TO_CONNECT(I18nMarker.marktr("Trouble connecting to people")),
        NONE(I18nMarker.marktr("No problems."));

        private final String message;

        private ErrorState(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum DownloadItemType {
        GNUTELLA,
        BITTORRENT,
        ANTIVIRUS;

    }
}

