/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.limewire.collection.Trie;

public final class TrieUtils {
    private TrieUtils() {
    }

    public static <K, V> List<V> select(Trie<K, V> trie, K key, int count) {
        return TrieUtils.select(trie, key, count, null);
    }

    public static <K, V> List<V> select(Trie<K, V> trie, K key, int count, final Trie.Cursor<K, V> cursor) {
        final int size = Math.min(trie.size(), count);
        final ArrayList values = new ArrayList(size);
        trie.select(key, new Trie.Cursor<K, V>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends K, ? extends V> entry) {
                if (cursor == null || cursor.select(entry) == Trie.Cursor.SelectStatus.EXIT) {
                    values.add(entry.getValue());
                }
                return values.size() >= size ? Trie.Cursor.SelectStatus.EXIT : Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return values;
    }
}

