/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;

public class FrameBodyIPLS
extends AbstractID3v2FrameBody
implements ID3v23FrameBody {
    public FrameBodyIPLS() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyIPLS(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    @Override
    public String getIdentifier() {
        return "IPLS";
    }

    public FrameBodyIPLS(FrameBodyIPLS body) {
        super(body);
    }

    public FrameBodyIPLS(FrameBodyTIPL body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        String valueAsCommaSeperatedString = (String)body.getObjectValue("Text");
        PairedTextEncodedStringNullTerminated.ValuePairs value = new PairedTextEncodedStringNullTerminated.ValuePairs();
        StringTokenizer stz = new StringTokenizer(valueAsCommaSeperatedString, ",");
        while (stz.hasMoreTokens()) {
            value.add(stz.nextToken());
        }
        this.setObjectValue("Text", value);
    }

    @Override
    public void write(ByteArrayOutputStream tagBuffer) {
        if (!((PairedTextEncodedStringNullTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(tagBuffer);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PairedTextEncodedStringNullTerminated("Text", this));
    }

    public String getValueAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getList().get(index);
    }

    public int getNumberOfValues() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getNumberOfValues();
    }

    public int getNumberOfPairs() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getNumberOfPairs();
    }
}

