/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.UnableToCreateFileException;
import org.jaudiotagger.audio.exceptions.UnableToModifyFileException;
import org.jaudiotagger.audio.exceptions.UnableToRenameFileException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.FileSystemMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.id3.AbstractID3Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyUrlLink;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPOPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.jaudiotagger.tag.reference.PictureTypes;

public abstract class AbstractID3v2Tag
extends AbstractID3Tag
implements Tag {
    protected static final String TYPE_HEADER = "header";
    protected static final String TYPE_BODY = "body";
    protected static final byte[] TAG_ID = new byte[]{73, 68, 51};
    public static final int TAG_HEADER_LENGTH = 10;
    protected static final int FIELD_TAGID_LENGTH = 3;
    protected static final int FIELD_TAG_MAJOR_VERSION_LENGTH = 1;
    protected static final int FIELD_TAG_MINOR_VERSION_LENGTH = 1;
    protected static final int FIELD_TAG_FLAG_LENGTH = 1;
    protected static final int FIELD_TAG_SIZE_LENGTH = 4;
    protected static final int FIELD_TAGID_POS = 0;
    protected static final int FIELD_TAG_MAJOR_VERSION_POS = 3;
    protected static final int FIELD_TAG_MINOR_VERSION_POS = 4;
    protected static final int FIELD_TAG_FLAG_POS = 5;
    protected static final int FIELD_TAG_SIZE_POS = 6;
    protected static final int TAG_SIZE_INCREMENT = 100;
    private static final long MAXIMUM_WRITABLE_CHUNK_SIZE = 10000000L;
    public HashMap frameMap = null;
    protected static final String TYPE_DUPLICATEFRAMEID = "duplicateFrameId";
    protected String duplicateFrameId = "";
    protected static final String TYPE_DUPLICATEBYTES = "duplicateBytes";
    protected int duplicateBytes = 0;
    protected static final String TYPE_EMPTYFRAMEBYTES = "emptyFrameBytes";
    protected int emptyFrameBytes = 0;
    protected static final String TYPE_FILEREADSIZE = "fileReadSize";
    protected int fileReadSize = 0;
    protected static final String TYPE_INVALIDFRAMEBYTES = "invalidFrameBytes";
    protected int invalidFrameBytes = 0;

    public AbstractID3v2Tag() {
    }

    protected AbstractID3v2Tag(AbstractID3v2Tag copyObject) {
    }

    protected void copyPrimitives(AbstractID3v2Tag copyObject) {
        this.duplicateFrameId = new String(copyObject.duplicateFrameId);
        this.duplicateBytes = copyObject.duplicateBytes;
        this.emptyFrameBytes = copyObject.emptyFrameBytes;
        this.fileReadSize = copyObject.fileReadSize;
        this.invalidFrameBytes = copyObject.invalidFrameBytes;
    }

    protected abstract void copyFrames(AbstractID3v2Tag var1);

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getInvalidFrameBytes() {
        return this.invalidFrameBytes;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    public boolean hasFrame(String identifier) {
        return this.frameMap.containsKey(identifier);
    }

    public boolean hasFrameAndBody(String identifier) {
        if (this.hasFrame(identifier)) {
            Object o = this.getFrame(identifier);
            if (o instanceof AbstractID3v2Frame) {
                return !(((AbstractID3v2Frame)o).getBody() instanceof FrameBodyUnsupported);
            }
            return true;
        }
        return false;
    }

    public boolean hasFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String key = (String)iterator.next();
            if (!key.startsWith(identifier)) continue;
            found = true;
        }
        return found;
    }

    public Object getFrame(String identifier) {
        return this.frameMap.get(identifier);
    }

    @Override
    public String getFirst(String identifier) {
        AbstractID3v2Frame frame = this.getFirstField(identifier);
        if (frame == null) {
            return "";
        }
        if (frame.getBody() instanceof FrameBodyCOMM) {
            return ((FrameBodyCOMM)frame.getBody()).getText();
        }
        if (frame.getBody() instanceof FrameBodyUSLT) {
            return ((FrameBodyUSLT)frame.getBody()).getFirstTextValue();
        }
        if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            return ((AbstractFrameBodyTextInfo)frame.getBody()).getFirstTextValue();
        }
        if (frame.getBody() instanceof AbstractFrameBodyUrlLink) {
            return ((AbstractFrameBodyUrlLink)frame.getBody()).getUrlLink();
        }
        return frame.getBody().toString();
    }

    @Override
    public TagField getFirstField(TagFieldKey genericKey) throws KeyNotFoundException {
        List<TagField> fields = this.get(genericKey);
        if (fields.size() > 0) {
            return fields.get(0);
        }
        return null;
    }

    @Override
    public AbstractID3v2Frame getFirstField(String identifier) {
        Object object = this.getFrame(identifier);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (AbstractID3v2Frame)((List)object).get(0);
        }
        return (AbstractID3v2Frame)object;
    }

    public void setFrame(AbstractID3v2Frame frame) {
        this.frameMap.put(frame.getIdentifier(), frame);
    }

    protected abstract ID3Frames getID3Frames();

    @Override
    public void set(TagField field) throws FieldDataInvalidException {
        if (!(field instanceof AbstractID3v2Frame)) {
            throw new FieldDataInvalidException("Field " + field + " is not of type AbstractID3v2Frame");
        }
        AbstractID3v2Frame newFrame = (AbstractID3v2Frame)field;
        Object o = this.frameMap.get(field.getId());
        if (o == null || !this.getID3Frames().isMultipleAllowed(newFrame.getId())) {
            this.frameMap.put(field.getId(), field);
        } else if (o instanceof AbstractID3v2Frame) {
            AbstractID3v2Frame oldFrame = (AbstractID3v2Frame)o;
            if (newFrame.getBody() instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)newFrame.getBody()).getDescription().equals(((FrameBodyTXXX)oldFrame.getBody()).getDescription())) {
                    ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                    frames.add(oldFrame);
                    frames.add(newFrame);
                    this.frameMap.put(newFrame.getId(), frames);
                } else {
                    this.frameMap.put(newFrame.getId(), newFrame);
                }
            } else if (newFrame.getBody() instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)newFrame.getBody()).getDescription().equals(((FrameBodyWXXX)oldFrame.getBody()).getDescription())) {
                    ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                    frames.add(oldFrame);
                    frames.add(newFrame);
                    this.frameMap.put(newFrame.getId(), frames);
                } else {
                    this.frameMap.put(newFrame.getId(), newFrame);
                }
            } else if (newFrame.getBody() instanceof FrameBodyCOMM) {
                if (!((FrameBodyCOMM)newFrame.getBody()).getDescription().equals(((FrameBodyCOMM)oldFrame.getBody()).getDescription())) {
                    ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                    frames.add(oldFrame);
                    frames.add(newFrame);
                    this.frameMap.put(newFrame.getId(), frames);
                } else {
                    this.frameMap.put(newFrame.getId(), newFrame);
                }
            } else if (newFrame.getBody() instanceof FrameBodyUFID) {
                if (!((FrameBodyUFID)newFrame.getBody()).getOwner().equals(((FrameBodyUFID)oldFrame.getBody()).getOwner())) {
                    ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                    frames.add(oldFrame);
                    frames.add(newFrame);
                    this.frameMap.put(newFrame.getId(), frames);
                } else {
                    this.frameMap.put(newFrame.getId(), newFrame);
                }
            } else if (newFrame.getBody() instanceof FrameBodyUSLT) {
                if (!((FrameBodyUSLT)newFrame.getBody()).getDescription().equals(((FrameBodyUSLT)oldFrame.getBody()).getDescription())) {
                    ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                    frames.add(oldFrame);
                    frames.add(newFrame);
                    this.frameMap.put(newFrame.getId(), frames);
                } else {
                    this.frameMap.put(newFrame.getId(), newFrame);
                }
            } else if (newFrame.getBody() instanceof FrameBodyPOPM) {
                if (!((FrameBodyPOPM)newFrame.getBody()).getEmailToUser().equals(((FrameBodyPOPM)oldFrame.getBody()).getEmailToUser())) {
                    ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                    frames.add(oldFrame);
                    frames.add(newFrame);
                    this.frameMap.put(newFrame.getId(), frames);
                } else {
                    this.frameMap.put(newFrame.getId(), newFrame);
                }
            } else {
                ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
                frames.add(oldFrame);
                frames.add(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
            }
        } else if (o instanceof List) {
            ListIterator<AbstractID3v2Frame> li = ((List)o).listIterator();
            while (li.hasNext()) {
                AbstractID3v2Frame nextFrame = (AbstractID3v2Frame)li.next();
                if (newFrame.getBody() instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)newFrame.getBody()).getDescription().equals(((FrameBodyTXXX)nextFrame.getBody()).getDescription())) continue;
                    li.set(newFrame);
                    this.frameMap.put(newFrame.getId(), o);
                    return;
                }
                if (newFrame.getBody() instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)newFrame.getBody()).getDescription().equals(((FrameBodyWXXX)nextFrame.getBody()).getDescription())) continue;
                    li.set(newFrame);
                    this.frameMap.put(newFrame.getId(), o);
                    return;
                }
                if (newFrame.getBody() instanceof FrameBodyCOMM) {
                    if (!((FrameBodyCOMM)newFrame.getBody()).getDescription().equals(((FrameBodyCOMM)nextFrame.getBody()).getDescription())) continue;
                    li.set(newFrame);
                    this.frameMap.put(newFrame.getId(), o);
                    return;
                }
                if (newFrame.getBody() instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)newFrame.getBody()).getOwner().equals(((FrameBodyUFID)nextFrame.getBody()).getOwner())) continue;
                    li.set(newFrame);
                    this.frameMap.put(newFrame.getId(), o);
                    return;
                }
                if (newFrame.getBody() instanceof FrameBodyUSLT) {
                    if (!((FrameBodyUSLT)newFrame.getBody()).getDescription().equals(((FrameBodyUSLT)nextFrame.getBody()).getDescription())) continue;
                    li.set(newFrame);
                    this.frameMap.put(newFrame.getId(), o);
                    return;
                }
                if (!(newFrame.getBody() instanceof FrameBodyPOPM) || !((FrameBodyPOPM)newFrame.getBody()).getEmailToUser().equals(((FrameBodyPOPM)nextFrame.getBody()).getEmailToUser())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), o);
                return;
            }
            ((List)o).add(newFrame);
        }
    }

    @Override
    public void setAlbum(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createAlbumField(s));
    }

    @Override
    public void setArtist(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createArtistField(s));
    }

    @Override
    public void setComment(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createCommentField(s));
    }

    @Override
    public void setGenre(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createGenreField(s));
    }

    @Override
    public void setTitle(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createTitleField(s));
    }

    @Override
    public void setTrack(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createTrackField(s));
    }

    @Override
    public void setYear(String s) throws FieldDataInvalidException {
        if (s == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.set(this.createYearField(s));
    }

    @Override
    public void add(TagField field) throws FieldDataInvalidException {
        if (field == null) {
            return;
        }
        if (!(field instanceof AbstractID3v2Frame)) {
            throw new FieldDataInvalidException("Field " + field + " is not of type AbstractID3v2Frame");
        }
        Object o = this.frameMap.get(field.getId());
        if (o instanceof List) {
            List list = (List)o;
            list.add(field);
        } else if (o == null) {
            this.frameMap.put(field.getId(), field);
        } else {
            ArrayList<TagField> list = new ArrayList<TagField>();
            list.add((TagField)o);
            list.add(field);
            this.frameMap.put(field.getId(), list);
        }
    }

    @Override
    public void addAlbum(String album) throws FieldDataInvalidException {
        if (album == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createAlbumField(album));
    }

    @Override
    public void addArtist(String artist) throws FieldDataInvalidException {
        if (artist == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createArtistField(artist));
    }

    @Override
    public void addComment(String comment) throws FieldDataInvalidException {
        if (comment == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createCommentField(comment));
    }

    @Override
    public void addGenre(String genre) throws FieldDataInvalidException {
        if (genre == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createGenreField(genre));
    }

    @Override
    public void addTitle(String title) throws FieldDataInvalidException {
        if (title == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createTitleField(title));
    }

    @Override
    public void addTrack(String track) throws FieldDataInvalidException {
        if (track == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createTrackField(track));
    }

    @Override
    public void addYear(String year) throws FieldDataInvalidException {
        if (year == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.add(this.createYearField(year));
    }

    public void setFrame(String identifier, List<AbstractID3v2Frame> multiFrame) {
        this.frameMap.put(identifier, multiFrame);
    }

    public int getFrameCount() {
        if (this.frameMap == null) {
            return 0;
        }
        return this.frameMap.size();
    }

    public Iterator getFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        HashSet result = new HashSet();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(identifier)) continue;
            result.add(this.frameMap.get(key));
        }
        return result.iterator();
    }

    @Override
    public void delete(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        FileChannel fc = file.getChannel();
        fc.position();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        fc.read(byteBuffer, 0L);
        byteBuffer.flip();
        if (this.seek(byteBuffer)) {
            file.seek(0L);
            file.write(buffer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2Tag)) {
            return false;
        }
        AbstractID3v2Tag object = (AbstractID3v2Tag)obj;
        if (!this.frameMap.equals(object.frameMap)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Iterator iterator() {
        return this.frameMap.values().iterator();
    }

    public void removeFrame(String identifier) {
        this.frameMap.remove(identifier);
    }

    public void removeUnsupportedFrames() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof AbstractID3v2Frame) || !(((AbstractID3v2Frame)o).getBody() instanceof FrameBodyUnsupported)) continue;
            i.remove();
        }
    }

    public void removeFrameOfType(String identifier) {
        HashSet<String> result = new HashSet<String>();
        for (Object k : this.frameMap.keySet()) {
            String key = (String)k;
            if (!key.startsWith(identifier)) continue;
            result.add(key);
        }
        for (String string : result) {
            this.frameMap.remove(string);
        }
    }

    public void write(File file, long audioStartByte) throws IOException {
    }

    protected FileLock getFileLockForWriting(FileChannel fileChannel, String filePath) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.tryLock();
        }
        catch (IOException exception) {
            return null;
        }
        if (fileLock == null) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(filePath));
        }
        return fileLock;
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
    }

    public void write(WritableByteChannel channel) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getV2TagSizeIfExists(File file) throws IOException {
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        ByteBuffer bb = null;
        try {
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            bb = ByteBuffer.allocate(10);
            ((FileChannel)fc).read(bb);
            bb.flip();
            if (bb.limit() < 10) {
                long l = 0L;
                return l;
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        byte[] tagIdentifier = new byte[3];
        bb.get(tagIdentifier, 0, 3);
        if (!Arrays.equals(tagIdentifier, TAG_ID)) {
            return 0L;
        }
        byte majorVersion = bb.get();
        if (majorVersion != 2 && majorVersion != 3 && majorVersion != 4) {
            return 0L;
        }
        bb.get();
        bb.get();
        int frameSize = ID3SyncSafeInteger.bufferToValue(bb);
        return frameSize += 10;
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byte[] tagIdentifier = new byte[3];
        byteBuffer.get(tagIdentifier, 0, 3);
        if (!Arrays.equals(tagIdentifier, TAG_ID)) {
            return false;
        }
        if (byteBuffer.get() != this.getMajorVersion()) {
            return false;
        }
        return byteBuffer.get() == this.getRevision();
    }

    protected int calculateTagSize(int tagSize, int audioStart) {
        if (tagSize <= audioStart) {
            return audioStart;
        }
        return tagSize + 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustPadding(File file, int paddingSize, long audioStart) throws FileNotFoundException, IOException {
        File paddedFile;
        AbstractInterruptibleChannel fcIn = null;
        FileChannel fcOut = null;
        ByteBuffer paddingBuffer = ByteBuffer.wrap(new byte[paddingSize]);
        try {
            paddedFile = File.createTempFile(Utils.getMinBaseFilenameAllowedForTempFile(file), ".new", file.getParentFile());
        }
        catch (IOException ioe) {
            if (ioe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            }
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
        }
        try {
            fcOut = new FileOutputStream(paddedFile).getChannel();
        }
        catch (FileNotFoundException ioe) {
            throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_MODIFY_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
        }
        FileLock fileTmpLock = null;
        try {
            fileTmpLock = this.getFileLockForWriting(fcOut, paddedFile.getPath());
            fcIn = new FileInputStream(file).getChannel();
            long written = fcOut.write(paddingBuffer);
            long audiolength = file.length() - audioStart;
            if (audiolength <= 10000000L) {
                long written2 = ((FileChannel)fcIn).transferTo(audioStart, audiolength, fcOut);
                if (written2 != audiolength) {
                    throw new RuntimeException(ErrorMessage.MP3_UNABLE_TO_ADJUST_PADDING.getMsg(audiolength, written2));
                }
            } else {
                long noOfChunks = audiolength / 10000000L;
                long lastChunkSize = audiolength % 10000000L;
                long written2 = 0L;
                int i = 0;
                while ((long)i < noOfChunks) {
                    written2 += ((FileChannel)fcIn).transferTo(audioStart + (long)i * 10000000L, 10000000L, fcOut);
                    Runtime.getRuntime().gc();
                    ++i;
                }
                if ((written2 += ((FileChannel)fcIn).transferTo(audioStart + noOfChunks * 10000000L, lastChunkSize, fcOut)) != audiolength) {
                    throw new RuntimeException(ErrorMessage.MP3_UNABLE_TO_ADJUST_PADDING.getMsg(audiolength, written2));
                }
            }
            long lastModified = file.lastModified();
            if (fcIn != null && fcIn.isOpen()) {
                fcIn.close();
            }
            if (fcOut != null && fcOut.isOpen()) {
                if (fileTmpLock != null && fileTmpLock.isValid()) {
                    fileTmpLock.release();
                }
                fcOut.close();
            }
            this.replaceFile(file, paddedFile);
            paddedFile.setLastModified(lastModified);
        }
        finally {
            try {
                if (fcIn != null && fcIn.isOpen()) {
                    fcIn.close();
                }
                if (fcOut != null && fcOut.isOpen()) {
                    if (fileTmpLock != null && fileTmpLock.isValid()) {
                        fileTmpLock.release();
                    }
                    fcOut.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected void writeBufferToFile(File file, ByteBuffer headerBuffer, byte[] bodyByteBuffer, int padding, int sizeIncPadding, long audioStartLocation) throws IOException {
        FileChannel fc = null;
        FileLock fileLock = null;
        if ((long)sizeIncPadding > audioStartLocation) {
            this.adjustPadding(file, sizeIncPadding, audioStartLocation);
        }
        try {
            fc = new RandomAccessFile(file, "rw").getChannel();
            fileLock = this.getFileLockForWriting(fc, file.getPath());
            fc.write(headerBuffer);
            fc.write(ByteBuffer.wrap(bodyByteBuffer));
            fc.write(ByteBuffer.wrap(new byte[padding]));
        }
        catch (FileNotFoundException fe) {
            if (fe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
            }
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
        }
        catch (IOException ioe) {
            if (ioe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
            }
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
        }
        finally {
            if (fc != null) {
                if (fileLock != null) {
                    fileLock.release();
                }
                fc.close();
            }
        }
    }

    private void replaceFile(File originalFile, File newFile) throws IOException {
        File originalFileBackup = new File(originalFile.getParentFile().getPath(), AudioFile.getBaseFilename(originalFile) + ".old");
        boolean renameOriginalResult = originalFile.renameTo(originalFileBackup);
        if (!renameOriginalResult) {
            throw new UnableToRenameFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(originalFile.getAbsolutePath(), originalFileBackup.getName()));
        }
        boolean renameResult = newFile.renameTo(originalFile);
        if (!renameResult) {
            if (!newFile.exists()) {
                // empty if block
            }
            if (!(renameOriginalResult = originalFileBackup.renameTo(originalFile))) {
                // empty if block
            }
            throw new UnableToRenameFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(originalFile.getAbsolutePath(), newFile.getName()));
        }
        boolean deleteResult = originalFileBackup.delete();
        if (!deleteResult) {
            // empty if block
        }
    }

    protected void copyFrameIntoMap(String id, AbstractID3v2Frame newFrame) {
        if (this.frameMap.containsKey(newFrame.getIdentifier())) {
            AbstractID3v2Frame firstFrame = (AbstractID3v2Frame)this.frameMap.get(newFrame.getIdentifier());
            if (newFrame.getBody() instanceof FrameBodyTDRC) {
                if (firstFrame.getBody() instanceof FrameBodyTDRC) {
                    FrameBodyTDRC body = (FrameBodyTDRC)firstFrame.getBody();
                    FrameBodyTDRC newBody = (FrameBodyTDRC)newFrame.getBody();
                    String bodyID = newBody.getOriginalID();
                    if ("TYER".equals(bodyID)) {
                        body.setYear(newBody.getText());
                    } else if ("TDAT".equals(bodyID)) {
                        body.setDate(newBody.getText());
                    } else if ("TIME".equals(bodyID)) {
                        body.setTime(newBody.getText());
                    } else if ("TRDA".equals(bodyID)) {
                        body.setReco(newBody.getText());
                    }
                } else if (firstFrame.getBody() instanceof FrameBodyUnsupported) {
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
            }
        } else {
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    protected void loadFrameIntoMap(String frameId, AbstractID3v2Frame next) {
        if (ID3v24Frames.getInstanceOf().isMultipleAllowed(frameId) || ID3v23Frames.getInstanceOf().isMultipleAllowed(frameId) || ID3v22Frames.getInstanceOf().isMultipleAllowed(frameId)) {
            if (this.frameMap.containsKey(frameId)) {
                Object o = this.frameMap.get(frameId);
                if (o instanceof ArrayList) {
                    ArrayList multiValues = (ArrayList)o;
                    multiValues.add(next);
                } else {
                    ArrayList<AbstractID3v2Frame> multiValues = new ArrayList<AbstractID3v2Frame>();
                    multiValues.add((AbstractID3v2Frame)o);
                    multiValues.add(next);
                    this.frameMap.put(frameId, multiValues);
                }
            } else {
                this.frameMap.put(frameId, next);
            }
        } else if (this.frameMap.containsKey(frameId)) {
            this.duplicateFrameId = this.duplicateFrameId + frameId + "; ";
            this.duplicateBytes += ((AbstractID3v2Frame)this.frameMap.get(frameId)).getSize();
        } else {
            this.frameMap.put(frameId, next);
        }
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Object o : this.frameMap.values()) {
            AbstractID3v2Frame frame;
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                size += frame.getSize();
                continue;
            }
            ArrayList multiFrames = (ArrayList)o;
            ListIterator li = multiFrames.listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                size += frame.getSize();
            }
        }
        return size;
    }

    protected ByteArrayOutputStream writeFramesToBuffer() throws IOException {
        ByteArrayOutputStream bodyBuffer = new ByteArrayOutputStream();
        TreeSet sortedWriteOrder = new TreeSet(this.getPreferredFrameOrderComparator());
        sortedWriteOrder.addAll(this.frameMap.keySet());
        for (String id : sortedWriteOrder) {
            AbstractID3v2Frame frame;
            Object o = this.frameMap.get(id);
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                frame.write(bodyBuffer);
                continue;
            }
            ArrayList multiFrames = (ArrayList)o;
            ListIterator li = multiFrames.listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                frame.write(bodyBuffer);
            }
        }
        return bodyBuffer;
    }

    public abstract Comparator getPreferredFrameOrderComparator();

    public void createStructure() {
        this.createStructureHeader();
        this.createStructureBody();
    }

    public void createStructureHeader() {
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEBYTES, this.duplicateBytes);
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEFRAMEID, this.duplicateFrameId);
        MP3File.getStructureFormatter().addElement(TYPE_EMPTYFRAMEBYTES, this.emptyFrameBytes);
        MP3File.getStructureFormatter().addElement(TYPE_FILEREADSIZE, this.fileReadSize);
        MP3File.getStructureFormatter().addElement(TYPE_INVALIDFRAMEBYTES, this.invalidFrameBytes);
    }

    public void createStructureBody() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_BODY, "");
        for (Object o : this.frameMap.values()) {
            AbstractID3v2Frame frame;
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                frame.createStructure();
                continue;
            }
            ArrayList multiFrames = (ArrayList)o;
            ListIterator li = multiFrames.listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                frame.createStructure();
            }
        }
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_BODY);
    }

    @Override
    public List<TagField> get(String id) throws KeyNotFoundException {
        Object o = this.getFrame(id);
        if (o == null) {
            return new ArrayList<TagField>();
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof AbstractID3v2Frame) {
            ArrayList<TagField> list = new ArrayList<TagField>();
            list.add((TagField)o);
            return list;
        }
        throw new RuntimeException("Found entry in frameMap that was not a frame or a list:" + o);
    }

    @Override
    public List<TagField> getAlbum() {
        return this.get(this.getAlbumId());
    }

    @Override
    public List<TagField> getArtist() {
        return this.get(this.getArtistId());
    }

    @Override
    public List<TagField> getComment() {
        return this.get(this.getCommentId());
    }

    @Override
    public List<TagField> getGenre() {
        return this.get(this.getGenreId());
    }

    @Override
    public List<TagField> getTitle() {
        return this.get(this.getTitleId());
    }

    @Override
    public List<TagField> getTrack() {
        return this.get(this.getTrackId());
    }

    @Override
    public List<TagField> getYear() {
        return this.get(this.getYearId());
    }

    @Override
    public String getFirstAlbum() {
        return this.getFirst(this.getAlbumId());
    }

    @Override
    public String getFirstArtist() {
        return this.getFirst(this.getArtistId());
    }

    @Override
    public String getFirstComment() {
        return this.getFirst(this.getCommentId());
    }

    @Override
    public String getFirstGenre() {
        return this.getFirst(this.getGenreId());
    }

    @Override
    public String getFirstTitle() {
        return this.getFirst(this.getTitleId());
    }

    @Override
    public String getFirstTrack() {
        return this.getFirst(this.getTrackId());
    }

    @Override
    public String getFirstYear() {
        return this.getFirst(this.getYearId());
    }

    protected abstract String getArtistId();

    protected abstract String getAlbumId();

    protected abstract String getTitleId();

    protected abstract String getTrackId();

    protected abstract String getYearId();

    protected abstract String getCommentId();

    protected abstract String getGenreId();

    public abstract AbstractID3v2Frame createFrame(String var1);

    public TagField createArtistField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getArtistId());
        ((AbstractFrameBodyTextInfo)frame.getBody()).setText(content);
        return frame;
    }

    public TagField createAlbumField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getAlbumId());
        ((AbstractFrameBodyTextInfo)frame.getBody()).setText(content);
        return frame;
    }

    public TagField createTitleField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getTitleId());
        ((AbstractFrameBodyTextInfo)frame.getBody()).setText(content);
        return frame;
    }

    public TagField createTrackField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getTrackId());
        ((AbstractFrameBodyTextInfo)frame.getBody()).setText(content);
        return frame;
    }

    public TagField createYearField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getYearId());
        ((AbstractFrameBodyTextInfo)frame.getBody()).setText(content);
        return frame;
    }

    public TagField createCommentField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getCommentId());
        ((FrameBodyCOMM)frame.getBody()).setText(content);
        return frame;
    }

    public TagField createGenreField(String content) {
        AbstractID3v2Frame frame = this.createFrame(this.getGenreId());
        ((AbstractFrameBodyTextInfo)frame.getBody()).setText(content);
        return frame;
    }

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(String id) {
        return this.get(id).size() != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.frameMap.size() == 0;
    }

    @Override
    public Iterator<TagField> getFields() {
        final Iterator it = this.frameMap.entrySet().iterator();
        final Iterator itHasNext = this.frameMap.entrySet().iterator();
        return new Iterator<TagField>(){
            Map.Entry<String, Object> latestEntry = null;
            private Iterator<TagField> fieldsIt;

            private void changeIt() {
                if (!it.hasNext()) {
                    return;
                }
                while (it.hasNext()) {
                    ArrayList<TagField> l;
                    Map.Entry e = (Map.Entry)it.next();
                    this.latestEntry = (Map.Entry)itHasNext.next();
                    if (e.getValue() instanceof List) {
                        l = (ArrayList<TagField>)e.getValue();
                        if (l.size() == 0) continue;
                        this.fieldsIt = l.iterator();
                        break;
                    }
                    l = new ArrayList<TagField>();
                    l.add((TagField)e.getValue());
                    this.fieldsIt = l.iterator();
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fieldsIt != null && this.fieldsIt.hasNext()) {
                    return true;
                }
                if (!itHasNext.hasNext()) {
                    return false;
                }
                return itHasNext.hasNext();
            }

            @Override
            public TagField next() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                if (this.fieldsIt != null && !this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                if (this.fieldsIt == null) {
                    throw new NoSuchElementException();
                }
                return this.fieldsIt.next();
            }

            @Override
            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> it = this.getFields();
        int count = 0;
        try {
            while (true) {
                it.next();
                ++count;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return count;
        }
    }

    @Override
    public boolean setEncoding(String enc) throws FieldDataInvalidException {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    @Override
    public String getFirst(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.doGetFirst(this.getFrameAndSubIdFromGenericKey(genericKey));
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.doCreateTagField(this.getFrameAndSubIdFromGenericKey(genericKey), value);
    }

    protected TagField doCreateTagField(FrameAndSubId formatKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
        if (frame.getBody() instanceof FrameBodyUFID) {
            ((FrameBodyUFID)frame.getBody()).setOwner(formatKey.getSubId());
            try {
                ((FrameBodyUFID)frame.getBody()).setUniqueIdentifier(value.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("When encoding UFID charset ISO-8859-1 was deemed unsupported");
            }
        } else if (frame.getBody() instanceof FrameBodyTXXX) {
            ((FrameBodyTXXX)frame.getBody()).setDescription(formatKey.getSubId());
            ((FrameBodyTXXX)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyWXXX) {
            ((FrameBodyWXXX)frame.getBody()).setDescription(formatKey.getSubId());
            ((FrameBodyWXXX)frame.getBody()).setUrlLink(value);
        } else if (frame.getBody() instanceof FrameBodyCOMM) {
            ((FrameBodyCOMM)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyUSLT) {
            ((FrameBodyUSLT)frame.getBody()).setDescription("");
            ((FrameBodyUSLT)frame.getBody()).setLyric(value);
        } else if (frame.getBody() instanceof FrameBodyWOAR) {
            ((FrameBodyWOAR)frame.getBody()).setUrlLink(value);
        } else if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            ((AbstractFrameBodyTextInfo)frame.getBody()).setText(value);
        } else {
            if (frame.getBody() instanceof FrameBodyAPIC || frame.getBody() instanceof FrameBodyPIC) {
                throw new UnsupportedOperationException("Please use createArtwork() instead for creating artwork");
            }
            throw new FieldDataInvalidException("Field with key of:" + formatKey.getFrameId() + ":does not accept cannot parse data:" + value);
        }
        return frame;
    }

    protected String doGetFirst(FrameAndSubId formatKey) throws KeyNotFoundException {
        if (formatKey.getSubId() == null) {
            return this.getFirst(formatKey.getFrameId());
        }
        List<TagField> list = this.get(formatKey.getFrameId());
        ListIterator<TagField> li = list.listIterator();
        while (li.hasNext()) {
            AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
            if (next instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                return ((FrameBodyTXXX)next).getText();
            }
            if (next instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                return ((FrameBodyWXXX)next).getUrlLink();
            }
            if (next instanceof FrameBodyUFID) {
                if (((FrameBodyUFID)next).getUniqueIdentifier().equals(formatKey.getSubId())) continue;
                return new String(((FrameBodyUFID)next).getUniqueIdentifier());
            }
            throw new RuntimeException("Need to implement get(TagFieldKey genericKey) for:" + next.getClass());
        }
        return "";
    }

    public TagField createLinkedArtworkField(String url) {
        AbstractID3v2Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(TagFieldKey.COVER_ART).getFrameId());
        if (frame.getBody() instanceof FrameBodyAPIC) {
            FrameBodyAPIC body = (FrameBodyAPIC)frame.getBody();
            body.setObjectValue("PictureData", Utils.getDefaultBytes(url, "ISO-8859-1"));
            body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            body.setObjectValue("MIMEType", "-->");
            body.setObjectValue("Description", "");
        } else if (frame.getBody() instanceof FrameBodyPIC) {
            FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
            body.setObjectValue("PictureData", Utils.getDefaultBytes(url, "ISO-8859-1"));
            body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            body.setObjectValue("ImageType", "-->");
            body.setObjectValue("Description", "");
        }
        return frame;
    }

    @Override
    public void deleteTagField(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        this.doDeleteTagField(formatKey);
    }

    protected void doDeleteTagField(FrameAndSubId formatKey) throws KeyNotFoundException {
        if (formatKey.getSubId() == null) {
            this.removeFrame(formatKey.getFrameId());
        } else {
            List<TagField> list = this.get(formatKey.getFrameId());
            ListIterator<TagField> li = list.listIterator();
            while (li.hasNext()) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)next).getUniqueIdentifier().equals(formatKey.getSubId())) continue;
                    li.remove();
                    continue;
                }
                throw new RuntimeException("Need to implement get(TagFieldKey genericKey) for:" + next.getClass());
            }
        }
    }

    protected abstract FrameAndSubId getFrameAndSubIdFromGenericKey(TagFieldKey var1);

    @Override
    public List<TagField> get(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        List<TagField> list = this.get(formatKey.getFrameId());
        ArrayList<TagField> filteredList = new ArrayList<TagField>();
        String subFieldId = formatKey.getSubId();
        String frameid = formatKey.getFrameId();
        if (subFieldId != null) {
            for (TagField tagfield : list) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)tagfield).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)next).getUniqueIdentifier().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                throw new RuntimeException("Need to implement get(TagFieldKey genericKey) for:" + next.getClass());
            }
            return filteredList;
        }
        return list;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void createAndSetArtworkField(Artwork artwork) throws FieldDataInvalidException {
        this.set(this.createArtworkField(artwork));
    }

    class FrameAndSubId {
        private String frameId;
        private String subId;

        public FrameAndSubId(String frameId, String subId) {
            this.frameId = frameId;
            this.subId = subId;
        }

        public String getFrameId() {
            return this.frameId;
        }

        public String getSubId() {
            return this.subId;
        }
    }
}

