/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;

public abstract class AudioFileReader {
    private static final int MINIMUM_SIZE_FOR_VALID_AUDIO_FILE = 150;

    protected abstract GenericAudioHeader getEncodingInfo(RandomAccessFile var1) throws CannotReadException, IOException;

    protected abstract Tag getTag(RandomAccessFile var1) throws CannotReadException, IOException;

    public AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        if (!f.canRead()) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(f.getAbsolutePath()));
        }
        if (f.length() <= 150L) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(f.getAbsolutePath()));
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            raf.seek(0L);
            GenericAudioHeader info = this.getEncodingInfo(raf);
            raf.seek(0L);
            Tag tag = this.getTag(raf);
            AudioFile audioFile = new AudioFile(f, (AudioHeader)info, tag);
            return audioFile;
        }
        catch (CannotReadException cre) {
            throw cre;
        }
        catch (Exception e) {
            throw new CannotReadException(f.getAbsolutePath() + ":" + e.getMessage(), e);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

