/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.asf.AsfFileReader;
import org.jaudiotagger.audio.asf.AsfFileWriter;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.flac.FlacFileReader;
import org.jaudiotagger.audio.flac.FlacFileWriter;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.audio.generic.ModificationHandler;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3FileReader;
import org.jaudiotagger.audio.mp3.MP3FileWriter;
import org.jaudiotagger.audio.mp4.Mp4FileReader;
import org.jaudiotagger.audio.mp4.Mp4FileWriter;
import org.jaudiotagger.audio.ogg.OggFileReader;
import org.jaudiotagger.audio.ogg.OggFileWriter;
import org.jaudiotagger.audio.real.RealFileReader;
import org.jaudiotagger.audio.wav.WavFileReader;
import org.jaudiotagger.audio.wav.WavFileWriter;
import org.jaudiotagger.tag.TagException;

public class AudioFileIO {
    private static AudioFileIO defaultInstance;
    private final ModificationHandler modificationHandler;
    private Map<String, AudioFileReader> readers = new HashMap<String, AudioFileReader>();
    private Map<String, AudioFileWriter> writers = new HashMap<String, AudioFileWriter>();

    public static void delete(AudioFile f) throws CannotReadException, CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().deleteTag(f);
    }

    public static AudioFileIO getDefaultAudioFileIO() {
        if (defaultInstance == null) {
            defaultInstance = new AudioFileIO();
        }
        return defaultInstance;
    }

    public static AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        return AudioFileIO.getDefaultAudioFileIO().readFile(f);
    }

    public static void write(AudioFile f) throws CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().writeFile(f);
    }

    public AudioFileIO() {
        this.modificationHandler = new ModificationHandler();
        this.prepareReadersAndWriters();
    }

    public void addAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationHandler.addAudioFileModificationListener(listener);
    }

    public void deleteTag(AudioFile f) throws CannotReadException, CannotWriteException {
        String ext = Utils.getExtension(f.getFile());
        AudioFileWriter afw = this.writers.get(ext);
        if (afw == null) {
            throw new CannotWriteException("No Deleter associated to this extension: " + ext);
        }
        afw.delete(f);
    }

    private void prepareReadersAndWriters() {
        this.readers.put(SupportedFileFormat.OGG.getFilesuffix(), new OggFileReader());
        this.readers.put(SupportedFileFormat.FLAC.getFilesuffix(), new FlacFileReader());
        this.readers.put(SupportedFileFormat.MP3.getFilesuffix(), new MP3FileReader());
        this.readers.put(SupportedFileFormat.MP4.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4A.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4P.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.WAV.getFilesuffix(), new WavFileReader());
        this.readers.put(SupportedFileFormat.WMA.getFilesuffix(), new AsfFileReader());
        RealFileReader realReader = new RealFileReader();
        this.readers.put(SupportedFileFormat.RA.getFilesuffix(), realReader);
        this.readers.put(SupportedFileFormat.RM.getFilesuffix(), realReader);
        this.writers.put(SupportedFileFormat.OGG.getFilesuffix(), new OggFileWriter());
        this.writers.put(SupportedFileFormat.FLAC.getFilesuffix(), new FlacFileWriter());
        this.writers.put(SupportedFileFormat.MP3.getFilesuffix(), new MP3FileWriter());
        this.writers.put(SupportedFileFormat.MP4.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4A.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4P.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.WAV.getFilesuffix(), new WavFileWriter());
        this.writers.put(SupportedFileFormat.WMA.getFilesuffix(), new AsfFileWriter());
        for (AudioFileWriter curr : this.writers.values()) {
            curr.setAudioFileModificationListener(this.modificationHandler);
        }
    }

    public AudioFile readFile(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        String ext = Utils.getExtension(f);
        AudioFileReader afr = this.readers.get(ext);
        if (afr == null) {
            throw new CannotReadException("No Reader associated to this extension: " + ext);
        }
        return afr.read(f);
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationHandler.removeAudioFileModificationListener(listener);
    }

    public void writeFile(AudioFile f) throws CannotWriteException {
        String ext = Utils.getExtension(f.getFile());
        AudioFileWriter afw = this.writers.get(ext);
        if (afw == null) {
            throw new CannotWriteException("No Writer associated to this extension: " + ext);
        }
        afw.write(f);
    }
}

