/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

public class FPSCounter {
    private int frames;
    private long start;

    public void reset() {
        this.start = 0L;
        this.frames = 0;
    }

    public void nextFrame() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        ++this.frames;
    }

    public int getNumFrames() {
        return this.frames;
    }

    public double getFPS() {
        long now = System.currentTimeMillis();
        return 1000.0 * (double)this.frames / (double)(now - this.start);
    }

    public String toString() {
        return "FPS: " + this.getFPS();
    }
}

