/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPHeader;
import net.sf.fmj.media.rtp.RTPParticipant;

public abstract class RTCPReport
implements Report {
    protected Participant participant;
    protected RTCPHeader header;
    protected Vector feedbackReports = new Vector();
    protected Vector sourceDescriptions = new Vector();
    protected int sdesBytes = 0;
    private String cName = null;
    private boolean isBye = false;
    private String byeReason = "";
    private long ssrc = 0L;

    public RTCPReport(byte[] data, int offset, int length) throws IOException {
        this.header = new RTCPHeader(data, offset, length);
        this.ssrc = this.header.getSsrc();
        if (this.header.getPadding() == 1) {
            throw new IOException("First packet has padding");
        }
        if ((this.header.getLength() + 1) * 4 >= length) {
            throw new IOException("Invalid Length");
        }
    }

    protected void readFeedbackReports(byte[] data, int offset, int length) throws IOException {
        for (int i = 0; i < this.header.getReceptionCount(); ++i) {
            RTCPFeedback feedback = new RTCPFeedback(data, offset, length);
            this.feedbackReports.add(feedback);
            offset += 24;
        }
    }

    protected void readSourceDescription(byte[] data, int offset, int length) throws IOException {
        RTCPHeader sdesHeader;
        if (length > 0 && (sdesHeader = new RTCPHeader(data, offset, length)).getPacketType() == 202) {
            this.ssrc = sdesHeader.getSsrc();
            this.sdesBytes = (sdesHeader.getLength() + 1) * 4;
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data, offset + 8, length));
            int type = 1;
            while (type != 0) {
                type = stream.readUnsignedByte();
                if (type == 0) continue;
                int len = stream.readUnsignedByte();
                byte[] desc = new byte[len];
                stream.readFully(desc);
                String descStr = new String(desc, "UTF-8");
                SourceDescription description = new SourceDescription(type, descStr, 0, false);
                this.sourceDescriptions.add(description);
                if (type != 1) continue;
                this.cName = descStr;
            }
        }
    }

    protected void readBye(byte[] data, int offset, int length) throws IOException {
        RTCPHeader sdesHeader;
        if (length > 0 && (sdesHeader = new RTCPHeader(data, offset, length)).getPacketType() == 203) {
            int len;
            this.isBye = true;
            if ((length + 1) * 4 > 8 && (len = data[offset + 8] & 0xFF) < length - 8 && len > 0) {
                this.byeReason = new String(data, offset + 8 + 1, len);
            }
        }
    }

    protected void setParticipant(RTPParticipant participant) {
        this.participant = participant;
        Vector streams = participant.getStreams();
        if (streams.size() == 0) {
            Vector sdes = participant.getSourceDescription();
            for (int i = 0; i < sdes.size(); ++i) {
                SourceDescription sdesItem = (SourceDescription)sdes.get(i);
                participant.addSourceDescription(sdesItem);
            }
        }
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public Vector getFeedbackReports() {
        return this.feedbackReports;
    }

    public Vector getSourceDescription() {
        return this.sourceDescriptions;
    }

    public String getCName() {
        return this.cName;
    }

    public boolean isByePacket() {
        return this.isBye;
    }

    public String getByeReason() {
        return this.byeReason;
    }
}

