/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import com.lti.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class XmlMovieMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean headerWritten = false;
    private boolean trailerWritten = false;

    public XmlMovieMux() {
        super(new ContentDescriptor("video.xml"));
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new VideoFormat(null, null, -1, Format.byteArray, -1.0f)};
    }

    public Format setInputFormat(Format format, int trackID) {
        logger.finer("setInputFormat " + format + " " + trackID);
        boolean match = false;
        for (Format supported : this.getSupportedInputFormats()) {
            if (!format.matches(supported)) continue;
            match = true;
            break;
        }
        if (!match) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[trackID] = format;
        }
        return format;
    }

    private void outputHeader(OutputStream os) throws IOException {
        os.write("<?xml version='1.0' encoding='utf-8'?>\n".getBytes());
        os.write("<XmlMovie version=\"1.0\">\n".getBytes());
        os.write("<Tracks>\n".getBytes());
        for (int i = 0; i < this.numTracks; ++i) {
            os.write(("\t<Track index=\"" + i + "\" format=\"" + StringUtils.replaceSpecialXMLChars(FormatArgUtils.toString(this.inputFormats[i])) + "\"/>\n").getBytes());
        }
        os.write("</Tracks>\n".getBytes());
    }

    private void outputTrailer(OutputStream os) throws IOException {
        os.write("</XmlMovie>\n".getBytes());
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        if (!this.headerWritten) {
            try {
                this.outputHeader(this.getOutputStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("" + e);
            }
            this.headerWritten = true;
        }
    }

    public void close() {
        if (!this.trailerWritten) {
            try {
                this.outputTrailer(this.getOutputStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
            this.trailerWritten = true;
        }
        super.close();
    }

    protected void doProcess(Buffer buffer, int trackID, OutputStream os) throws IOException {
        if (!this.headerWritten) {
            this.outputHeader(os);
            this.headerWritten = true;
        }
        if (buffer.isEOM()) {
            if (!this.trailerWritten) {
                this.outputTrailer(os);
                this.trailerWritten = true;
            }
            os.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append("<Buffer");
        b.append(" track=\"" + trackID + "\"");
        if (buffer.getSequenceNumber() != 0x7FFFFFFFFFFFFFFEL) {
            b.append(" sequenceNumber=\"" + buffer.getSequenceNumber() + "\"");
        }
        b.append(" timeStamp=\"" + buffer.getTimeStamp() + "\"");
        if (buffer.getDuration() >= 0L) {
            b.append(" duration=\"" + buffer.getDuration() + "\"");
        }
        if (buffer.getFlags() != 0) {
            b.append(" flags=\"" + Integer.toHexString(buffer.getFlags()) + "\"");
        }
        if (buffer.getFormat() != null && !buffer.getFormat().equals(this.inputFormats[trackID])) {
            b.append(" format=\"" + StringUtils.replaceSpecialXMLChars(FormatArgUtils.toString(buffer.getFormat())) + "\"");
        }
        b.append(">");
        b.append("<Data>");
        b.append(StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()));
        b.append("</Data>");
        b.append("</Buffer>\n");
        os.write(b.toString().getBytes());
    }
}

