/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.parser.RawPullStreamParser;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.utility.LoggerSingleton;

public class RawPullBufferParser
extends RawPullStreamParser {
    private static final Logger logger = LoggerSingleton.logger;
    static final String NAME = "Raw pull stream parser";

    public String getName() {
        return NAME;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        PullBufferDataSource pullBufferDataSource = (PullBufferDataSource)source;
        this.streams = pullBufferDataSource.getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] != null) continue;
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
    }

    protected boolean supports(SourceStream[] streams) {
        throw new UnsupportedOperationException();
    }

    public void open() {
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            PullBufferStream s = (PullBufferStream)this.streams[i];
            this.tracks[i] = new FrameTrack(this, s);
        }
    }

    class FrameTrack
    implements Track {
        Demultiplexer parser;
        PullBufferStream pbs;
        boolean enabled;
        Format format;
        TrackListener listener;
        Integer stateReq;

        FrameTrack(Demultiplexer parser, PullBufferStream pbs) {
            this.parser = parser;
            this.pbs = pbs;
            this.format = pbs.getFormat();
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Time getStartTime() {
            return TIME_UNKNOWN;
        }

        public void setTrackListener(TrackListener l) {
            this.listener = l;
        }

        public void readFrame(Buffer buffer) {
            try {
                this.pbs.read(buffer);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }
    }
}

