/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.google.inject.Singleton;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.SearchSettings;
import org.limewire.inspection.InspectablePrimitive;

@Singleton
class OutOfBandStatisticsImpl
implements OutOfBandStatistics {
    private static final Log LOG = LogFactory.getLog(OutOfBandStatisticsImpl.class);
    private static final int SAMPLE_SIZE = 500;
    @InspectablePrimitive(value="oob sample size")
    private AtomicInteger sampleSize = new AtomicInteger(500);
    @InspectablePrimitive(value="oob requested")
    private AtomicInteger requested = new AtomicInteger(0);
    @InspectablePrimitive(value="oob received")
    private AtomicInteger received = new AtomicInteger(0);
    @InspectablePrimitive(value="oob bypassed")
    private AtomicInteger bypassed = new AtomicInteger(0);
    @InspectablePrimitive(value="oob sent")
    private AtomicInteger sent = new AtomicInteger(0);

    OutOfBandStatisticsImpl() {
    }

    @Override
    public void addBypassedResponse(int numBypassed) {
        this.bypassed.addAndGet(numBypassed);
    }

    @Override
    public void addReceivedResponse(int numReceived) {
        this.received.addAndGet(numReceived);
    }

    @Override
    public void addRequestedResponse(int numRequested) {
        this.requested.addAndGet(numRequested);
    }

    @Override
    public void addSentQuery() {
        this.sent.incrementAndGet();
    }

    @Override
    public int getRequestedResponses() {
        return this.requested.get();
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize.get();
    }

    @Override
    public void increaseSampleSize() {
        this.sampleSize.addAndGet(500);
    }

    @Override
    public double getSuccessRate() {
        double numRequested = this.requested.doubleValue();
        double numReceived = this.received.doubleValue();
        return numReceived / numRequested * 100.0;
    }

    @Override
    public boolean isSuccessRateGood() {
        boolean good;
        if (this.requested.get() < this.sampleSize.get()) {
            LOG.debug("Assuming OOB success rate is good");
            return true;
        }
        int threshold = SearchSettings.OOB_SUCCESS_RATE_GOOD.getValue();
        boolean bl = good = this.getSuccessRate() > (double)threshold;
        if (LOG.isDebugEnabled()) {
            LOG.debug("OOB success rate of " + this.getSuccessRate() + "% is " + (good ? "" : "not ") + "good");
        }
        return good;
    }

    @Override
    public boolean isSuccessRateGreat() {
        boolean great;
        if (this.requested.get() < this.sampleSize.get()) {
            LOG.debug("Assuming OOB success rate is great");
            return true;
        }
        int threshold = SearchSettings.OOB_SUCCESS_RATE_GREAT.getValue();
        boolean bl = great = this.getSuccessRate() > (double)threshold;
        if (LOG.isDebugEnabled()) {
            LOG.debug("OOB success rate of " + this.getSuccessRate() + "% is " + (great ? "" : "not ") + "great");
        }
        return great;
    }

    @Override
    public boolean isSuccessRateTerrible() {
        boolean terrible;
        if (this.requested.get() < this.sampleSize.get()) {
            LOG.debug("Assuming OOB success rate is not terrible");
            return false;
        }
        int threshold = SearchSettings.OOB_SUCCESS_RATE_TERRIBLE.getValue();
        boolean bl = terrible = this.getSuccessRate() < (double)threshold;
        if (LOG.isDebugEnabled()) {
            LOG.debug("OOB success rate of " + this.getSuccessRate() + "% is " + (terrible ? "" : "not ") + "terrible");
        }
        return terrible;
    }

    @Override
    public boolean isOOBEffectiveForProxy() {
        boolean effective;
        if (SearchSettings.FORCE_OOB.getValue()) {
            return true;
        }
        boolean bl = effective = this.sent.get() <= 40 || this.requested.get() != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent " + this.sent.get() + " queries, requested " + this.requested.get() + " responses, OOB is " + (effective ? "" : "not ") + "effective for proxying");
        }
        return effective;
    }

    @Override
    public boolean isOOBEffectiveForMe() {
        boolean effective;
        if (SearchSettings.FORCE_OOB.getValue()) {
            return true;
        }
        boolean bl = effective = this.sent.get() <= 20 || this.requested.get() != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent " + this.sent.get() + " queries, requested " + this.requested.get() + " responses, OOB is " + (effective ? "" : "not ") + "effective for me");
        }
        return effective;
    }
}

