/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.spam.KeywordToken;
import java.util.Locale;

public class TemplateToken
extends KeywordToken {
    private static final float TEMPLATE_WEIGHT = 0.9f;
    private static final int SHORT_TEMPLATE_LENGTH = 8;
    private static final String REPLACEMENT_STRING = "****";
    private final float weight;

    private TemplateToken(String template) {
        super(template);
        int length = template.length() - REPLACEMENT_STRING.length();
        this.weight = length >= 8 ? 0.9f : 0.9f * (float)length / 8.0f;
    }

    public static TemplateToken create(String query, String filename) {
        query = query.trim().toLowerCase(Locale.US);
        if ((filename = filename.trim().toLowerCase(Locale.US)).contains(query) && !filename.equals(query)) {
            return new TemplateToken(filename.replace(query, REPLACEMENT_STRING));
        }
        return null;
    }

    @Override
    protected float getWeight() {
        return this.weight;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TemplateToken)) {
            return false;
        }
        return this.keyword.equals(((TemplateToken)o).keyword);
    }

    @Override
    public String toString() {
        return "template " + this.keyword;
    }
}

