/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimppParser {
    private static final Log LOG = LogFactory.getLog(SimppParser.class);
    private static final String VERSION = "version";
    private static final String PROPS = "props";
    private int _version;
    private String _propsData;

    public SimppParser(byte[] dataBytes) throws IOException {
        this.parseInfo(new String(dataBytes, "UTF-8"));
    }

    public int getVersion() {
        return this._version;
    }

    public String getPropsData() {
        return this._propsData;
    }

    private void parseInfo(String xmlStr) throws IOException {
        if (xmlStr == null || xmlStr.equals("")) {
            throw new IOException("null xml for version info");
        }
        Document d = XMLUtils.getDocument(xmlStr, LOG);
        Element docElement = d.getDocumentElement();
        NodeList children = docElement.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName().toLowerCase(Locale.US).trim();
            String value = LimeXMLUtils.getText(node.getChildNodes());
            if (nodeName.equals(VERSION)) {
                String ver = value;
                try {
                    this._version = Integer.parseInt(ver);
                }
                catch (NumberFormatException nfx) {
                    LOG.error("Unable to parse version number: " + nfx);
                    this._version = -1;
                }
                continue;
            }
            if (!nodeName.equals(PROPS)) continue;
            this._propsData = value;
        }
    }
}

