/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.ASFParser;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.video.VideoMetaData;
import java.io.File;
import java.io.IOException;

public class WMVMetaData
implements MetaReader {
    @Override
    public VideoMetaData parse(File f) throws IOException {
        return this.parse(new ASFParser(f));
    }

    public VideoMetaData parse(ASFParser parser) throws IOException {
        VideoMetaData videoData = new VideoMetaData();
        this.set(videoData, parser);
        return videoData;
    }

    private void set(VideoMetaData videoData, ASFParser data) throws IOException {
        if (!data.hasVideo()) {
            throw new IOException("no video data!");
        }
        videoData.setTitle(data.getTitle());
        videoData.setYear(data.getYear());
        videoData.setComment(data.getComment());
        videoData.setLength(data.getLength());
        videoData.setWidth(data.getWidth());
        videoData.setHeight(data.getHeight());
        if (data.getLicenseInfo() != null) {
            videoData.setLicenseType(data.getLicenseInfo());
        }
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"wmv"};
    }
}

