/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.messages.LocalPongInfo;
import org.limewire.util.ByteUtils;

@Singleton
public class LocalPongInfoImpl
implements LocalPongInfo {
    private final Provider<ConnectionManager> connectionManager;
    private final FileView gnutellaFileView;

    @Inject
    public LocalPongInfoImpl(Provider<ConnectionManager> connectionManager, @GnutellaFiles FileView gnutellaFileView) {
        this.connectionManager = connectionManager;
        this.gnutellaFileView = gnutellaFileView;
    }

    @Override
    public byte getNumFreeLimeWireNonLeafSlots() {
        return (byte)this.connectionManager.get().getNumFreeLimeWireNonLeafSlots();
    }

    @Override
    public byte getNumFreeLimeWireLeafSlots() {
        return (byte)this.connectionManager.get().getNumFreeLimeWireLeafSlots();
    }

    @Override
    public long getNumSharedFiles() {
        return this.gnutellaFileView.size();
    }

    @Override
    public int getSharedFileSize() {
        return ByteUtils.long2int(this.gnutellaFileView.getNumBytes());
    }

    @Override
    public boolean isSupernode() {
        return this.connectionManager.get().isSupernode();
    }
}

