/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryProvider;
import com.limegroup.gnutella.library.CreationTimeCache;
import com.limegroup.gnutella.library.DiskIo;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileCollectionManager;
import com.limegroup.gnutella.library.FileCollectionManagerImpl;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileDescChangeEvent;
import com.limegroup.gnutella.library.FileDescFactory;
import com.limegroup.gnutella.library.FileDescFactoryImpl;
import com.limegroup.gnutella.library.FileManager;
import com.limegroup.gnutella.library.FileManagerImpl;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import com.limegroup.gnutella.library.FileViewManager;
import com.limegroup.gnutella.library.FileViewManagerImpl;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.IncompleteFileCollection;
import com.limegroup.gnutella.library.IncompleteFileCollectionImpl;
import com.limegroup.gnutella.library.IncompleteFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryFileData;
import com.limegroup.gnutella.library.LibraryImpl;
import com.limegroup.gnutella.library.LibraryStatusEvent;
import com.limegroup.gnutella.library.LocalFileDetailsFactory;
import com.limegroup.gnutella.library.LocalFileDetailsFactoryImpl;
import com.limegroup.gnutella.library.SharedFileCollectionChangeEvent;
import com.limegroup.gnutella.library.SharedFileCollectionImpl;
import com.limegroup.gnutella.library.SharedFileCollectionImplFactory;
import com.limegroup.gnutella.library.SharedFiles;
import com.limegroup.gnutella.library.SharedFilesKeywordIndex;
import com.limegroup.gnutella.library.SharedFilesKeywordIndexImpl;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.core.api.library.FileProcessingEvent;
import org.limewire.inject.AbstractModule;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListenerList;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SourcedEventMulticaster;
import org.limewire.listener.SourcedEventMulticasterImpl;
import org.limewire.listener.SourcedListenerSupport;

public class LimeWireLibraryModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(LocalFileDetailsFactory.class).to(LocalFileDetailsFactoryImpl.class);
        this.bind(SharedFilesKeywordIndex.class).to(SharedFilesKeywordIndexImpl.class);
        this.bind(CreationTimeCache.class);
        this.bind(FileViewManager.class).to(FileViewManagerImpl.class);
        this.bind(FileCollectionManager.class).to(FileCollectionManagerImpl.class);
        this.bind(FileManager.class).to(FileManagerImpl.class);
        this.bind(Library.class).to(LibraryImpl.class);
        this.bind(IncompleteFileCollection.class).to(IncompleteFileCollectionImpl.class);
        this.bind(FileView.class).annotatedWith(IncompleteFiles.class).to(IncompleteFileCollection.class);
        this.bind(SharedFileCollectionImplFactory.class).toProvider(FactoryProvider.newFactory(SharedFileCollectionImplFactory.class, SharedFileCollectionImpl.class));
        EventListenerList.EventListenerListContext context = new EventListenerList.EventListenerListContext();
        SourcedEventMulticasterImpl allFileCollectionMulticaster = new SourcedEventMulticasterImpl(context);
        this.bind(new TypeLiteral<SourcedEventMulticaster<FileViewChangeEvent, FileView>>(){}).toInstance(allFileCollectionMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FileViewChangeEvent>>(){}).toInstance(allFileCollectionMulticaster);
        EventMulticasterImpl sharedAllFileCollectionMulticaster = new EventMulticasterImpl(context);
        this.bind(new TypeLiteral<EventBroadcaster<SharedFileCollectionChangeEvent>>(){}).toInstance(sharedAllFileCollectionMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<SharedFileCollectionChangeEvent>>(){}).toInstance(sharedAllFileCollectionMulticaster);
        EventMulticasterImpl managedListMulticaster = new EventMulticasterImpl();
        this.bind(new TypeLiteral<EventBroadcaster<LibraryStatusEvent>>(){}).toInstance(managedListMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<LibraryStatusEvent>>(){}).toInstance(managedListMulticaster);
        this.bind(new TypeLiteral<EventMulticaster<LibraryStatusEvent>>(){}).toInstance(managedListMulticaster);
        SourcedEventMulticasterImpl fileDescMulticaster = new SourcedEventMulticasterImpl();
        this.bind(new TypeLiteral<EventBroadcaster<FileDescChangeEvent>>(){}).toInstance(fileDescMulticaster);
        this.bind(new TypeLiteral<SourcedListenerSupport<FileDescChangeEvent, FileDesc>>(){}).toInstance(fileDescMulticaster);
        this.bind(new TypeLiteral<ListenerSupport<FileDescChangeEvent>>(){}).toInstance(fileDescMulticaster);
        this.bind(new TypeLiteral<SourcedEventMulticaster<FileDescChangeEvent, FileDesc>>(){}).toInstance(fileDescMulticaster);
        this.bind(FileDescFactory.class).to(FileDescFactoryImpl.class);
        ListeningExecutorService diskE = ExecutorsHelper.newProcessingQueue("Library Disk I/O Thread");
        this.bind(ListeningExecutorService.class).annotatedWith(DiskIo.class).toInstance(diskE);
        this.bind(ExecutorService.class).annotatedWith(DiskIo.class).toInstance(diskE);
        this.bind(Executor.class).annotatedWith(DiskIo.class).toInstance(diskE);
        EventListenerList processingList = new EventListenerList();
        this.bind(new TypeLiteral<EventListenerList<FileProcessingEvent>>(){}).toInstance(processingList);
        this.bind(new TypeLiteral<EventBroadcaster<FileProcessingEvent>>(){}).toInstance(processingList);
    }

    @Provides
    LibraryFileData lfd(LibraryImpl library) {
        return library.getLibraryData();
    }

    @Provides
    @GnutellaFiles
    FileCollection gnetFileCollection(FileCollectionManagerImpl manager) {
        return manager.getGnutellaCollection();
    }

    @Provides
    @GnutellaFiles
    FileView gnetFileView(FileViewManagerImpl manager) {
        return manager.getGnutellaFileView();
    }

    @Provides
    @SharedFiles
    FileView allSharedView(FileViewManagerImpl manager) {
        return manager.getAllSharedFilesView();
    }
}

