/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.filters.URNBlacklistManager;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.core.settings.FilterSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.Base32;
import org.limewire.util.CommonUtils;
import org.limewire.util.Visitor;

@EagerSingleton
class URNBlacklistManagerImpl
implements URNBlacklistManager,
Service {
    private static final Log LOG = LogFactory.getLog(URNBlacklistManagerImpl.class);
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final Provider<SpamServices> spamServices;
    private final AtomicBoolean updatedThisSession = new AtomicBoolean(false);

    @Inject
    URNBlacklistManagerImpl(Provider<HttpExecutor> httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, Provider<SpamServices> spamServices) {
        this.httpExecutor = httpExecutor;
        this.defaultParams = defaultParams;
        this.spamServices = spamServices;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void start() {
        LOG.debug("Starting");
        long now = System.currentTimeMillis();
        if (now > FilterSettings.NEXT_URN_BLACKLIST_UPDATE.getValue()) {
            this.checkForUpdate();
        } else {
            LOG.debug("Too soon to check for an update");
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Override
    public String getServiceName() {
        return "URNBlacklistManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void loadURNs(Visitor<String> visitor) {
        block12: {
            long read;
            long length;
            RandomAccessFile in;
            byte[] buf;
            block11: {
                buf = new byte[20];
                byte[] sig = new byte[46];
                in = null;
                File file = this.getFile();
                length = file.length() - 46L;
                if (length <= 0L || length > 200000L || length % 20L != 0L) {
                    LOG.debug("File is missing, empty, or an invalid size");
                    this.invalidFile();
                    return;
                }
                LOG.debug("Opening file");
                in = new RandomAccessFile(file, "r");
                Signature signature = Signature.getInstance("SHA1withDSA");
                byte[] keyBytes = Base32.decode("GCBADNZQQIASYBQHFKDERTRYAQATBAQBD4BIDAIA7V7VHAI5OUJCSUW7JKOC53HE473BDN2SHTXUIAGDDY7YBNSREZUUKXKAEJI7WWJ5RVMPVP6F6W5DB5WLTNKWZV4BHOAB2NDP6JTGBN3LTFIKLJE7T7UAI6YQELBE7O5J277LPRQ37A5VPZ6GVCTBKDYE7OB7NU6FD3BQENKUCNNBNEJS6Z27HLRLMHLSV37SEIBRTHORJAA4OAQVACLWAUEPCURQXTFSSK4YFIXLQQF7AWA46UBIDAIA67Q2BBOWTM655S54VNODNOCXXF4ZJL537I5OVAXZK5GAWPIHQJTVCWKXR25NIWKP4ZYQOEEBQC2ESFTREPUEYKAWCO346CJSRTEKNYJ4CZ5IWVD4RUUOBI5ODYV3HJTVSFXKG7YL7IQTKYXR7NRHUAJEHPGKJ4N6VBIZBCNIQPP6CWXFT4DJFC3GL2AHWVJFMQAUYO76Z5ESUA4BQQAAFAMAO23AF7C247RPE4RGGMCU3XQTRVG3ZIKKQUVAS2BKNDBDB3W7L375GYP7ZWZL2RP3WAIBOHZ52G7KT46EAGBUG7DWQNZS4IWC2GDVU4PQ74Q64BJWMK2DZ6G7GYESYHUPBNDOB5PLI2WPF33NIAOXNYQXSEJLTSPUXBMY3RHAQY3TRG6EKQ6CNNZJ2NRVY3RZXLAV3QMVENJIQ");
                KeyFactory factory = KeyFactory.getInstance("DSA");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
                PublicKey key = factory.generatePublic(keySpec);
                signature.initVerify(key);
                for (read = 0L; read < length; read += (long)buf.length) {
                    in.readFully(buf);
                    signature.update(buf);
                }
                in.readFully(sig);
                if (signature.verify(sig)) {
                    LOG.debug("Valid signature");
                    break block11;
                }
                LOG.debug("Invalid signature");
                this.invalidFile();
                IOUtils.close(in);
                return;
            }
            try {
                in.seek(0L);
                for (read = 0L; read < length; read += (long)buf.length) {
                    in.readFully(buf);
                    if (!visitor.visit(Base32.encode(buf))) break;
                }
            }
            catch (IOException e) {
                LOG.debug("Error loading URNs", e);
                this.invalidFile();
                IOUtils.close(in);
                break block12;
            }
            catch (GeneralSecurityException e2) {
                LOG.debug("Error verifying URNs", e2);
                this.invalidFile();
                {
                    catch (Throwable throwable) {
                        IOUtils.close(in);
                        throw throwable;
                    }
                }
                IOUtils.close(in);
            }
            IOUtils.close(in);
        }
    }

    private void invalidFile() {
        FilterSettings.LAST_URN_BLACKLIST_UPDATE.setValue(0L);
        this.checkForUpdate();
    }

    File getFile() {
        return new File(CommonUtils.getUserSettingsDir(), "urns.dat");
    }

    private void checkForUpdate() {
        String[] urls = FilterSettings.URN_BLACKLIST_UPDATE_URLS.get();
        if (urls.length == 0) {
            LOG.debug("No request URLs");
            this.setNextUpdateTime();
            return;
        }
        if (this.updatedThisSession.getAndSet(true)) {
            LOG.debug("Already updated this session");
            return;
        }
        int random = (int)(Math.random() * (double)urls.length);
        String url = urls[random];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending request to " + url);
        }
        this.sendRequest(new HttpHead(url));
    }

    private void sendRequest(HttpRequestBase request) {
        request.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 10000);
        HttpConnectionParams.setSoTimeout(params, 10000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.get().execute(request, params, new RequestHandler());
    }

    private void setNextUpdateTime() {
        long now = System.currentTimeMillis();
        FilterSettings.LAST_URN_BLACKLIST_UPDATE.setValue(now);
        long max = FilterSettings.MAX_URN_BLACKLIST_UPDATE_INTERVAL.getValue();
        long min = FilterSettings.MIN_URN_BLACKLIST_UPDATE_INTERVAL.getValue();
        long next = now + Math.max(min, (long)(Math.random() * (double)max));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting next update time to " + next);
        }
        FilterSettings.NEXT_URN_BLACKLIST_UPDATE.setValue(next);
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        @Override
        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            String method = request.getMethod();
            if ("HEAD".equals(method)) {
                LOG.debug("HEAD request completed");
                long modified = 0L;
                Header header = response.getFirstHeader("Last-Modified");
                if (header == null || header.getValue() == null) {
                    LOG.debug("Response has no Last-Modified header");
                } else {
                    try {
                        String date = header.getValue();
                        modified = DateUtils.parseDate(date).getTime();
                    }
                    catch (DateParseException e) {
                        LOG.debug("Error parsing date", e);
                    }
                }
                long last = FilterSettings.LAST_URN_BLACKLIST_UPDATE.getValue();
                if (modified > last) {
                    String url = request.getURI().toString();
                    URNBlacklistManagerImpl.this.sendRequest(new HttpGet(url));
                } else {
                    URNBlacklistManagerImpl.this.setNextUpdateTime();
                }
            } else if ("GET".equals(method)) {
                LOG.debug("GET request completed");
                HttpEntity body = response.getEntity();
                if (body == null) {
                    LOG.debug("Response has no body");
                } else {
                    BufferedOutputStream out = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(URNBlacklistManagerImpl.this.getFile()));
                        body.writeTo(out);
                        out.flush();
                        out.close();
                        ((SpamServices)URNBlacklistManagerImpl.this.spamServices.get()).reloadSpamFilters();
                        IOUtils.close(out);
                    }
                    catch (IOException e) {
                        LOG.debug("Error saving URNs", e);
                    }
                    finally {
                        IOUtils.close(out);
                    }
                }
                URNBlacklistManagerImpl.this.setNextUpdateTime();
            }
            return false;
        }

        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException e) {
            if (LOG.isDebugEnabled()) {
                String method = request.getMethod();
                String status = null;
                if (response != null) {
                    status = response.getStatusLine().toString();
                }
                LOG.debug(method + " request failed with status " + status, e);
            }
            URNBlacklistManagerImpl.this.setNextUpdateTime();
            return false;
        }
    }
}

