/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.common.collect.ImmutableList;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.response.ResponseFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PhraseFilter
implements SpamFilter,
ResponseFilter {
    private final List<String> ban;

    PhraseFilter() {
        this.ban = this.createDefaultList();
    }

    PhraseFilter(String ... phrases) {
        this.ban = ImmutableList.of(phrases);
    }

    private List<String> createDefaultList() {
        ImmutableList.Builder<String> builder = ImmutableList.builder();
        try {
            builder.add(new String(new byte[]{97, 46, 98, 46, 112, 46, 101, 46, 32, 49, 49, 32, 45, 115, 101, 114, 105, 101, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{97, 46, 98, 46, 112, 46, 101, 46, 112, 46, 116, 46}, "UTF8").intern());
            builder.add(new String(new byte[]{98, 97, 98, 121, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{98, 97, 98, 121, 102, 117, 99, 107, 105, 110, 103}, "UTF8").intern());
            builder.add(new String(new byte[]{98, 97, 98, 121, 115, 104, 105}, "UTF8").intern());
            builder.add(new String(new byte[]{98, 97, 98, 121, 115, 104, 105, 118, 105, 100}, "UTF8").intern());
            builder.add(new String(new byte[]{98, 111, 105, 105, 110, 116, 101, 114, 114, 117, 112, 116, 101, 100}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 97, 120, 97, 115, 101, 116}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 97, 110, 97, 108}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 97, 110, 97, 108}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 97, 115, 115, 102, 105, 105, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 97, 115, 115, 45, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 102, 117, 99, 107, 105, 110, 103}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 102, 117, 99, 107, 105, 110, 103}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 102, 117, 103, 103, 97}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 102, 117, 103, 103, 97}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 109, 111, 108, 101, 115, 116, 97, 116, 105, 111, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 112, 111, 114, 110, 111, 103, 114, 97, 112, 104, 121}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 112, 111, 114, 110, 111, 103, 114, 97, 112, 104, 121}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 114, 97, 112, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 45, 114, 97, 112, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 114, 101, 110, 102, 117, 99, 107, 105, 110, 103}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 114, 101, 110, 45, 102, 117, 99, 107, 105, 110, 103}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 114, 101, 110, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{99, 104, 105, 108, 100, 114, 101, 110, 45, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{100, 101, 101, 38, 100, 101, 115, 105}, "UTF8").intern());
            builder.add(new String(new byte[]{100, 111, 110, 110, 111, 118, 101, 110, 115, 111, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{102, 105, 114, 115, 116, 112, 117, 98, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{102, 105, 114, 115, 116, 45, 112, 117, 98, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{104, 116, 116, 112, 58, 47, 47, 49, 50, 51, 32, 46, 117, 115, 101, 111, 110, 46, 99, 111, 109}, "UTF8").intern());
            builder.add(new String(new byte[]{104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 112, 114, 101, 116, 101, 101, 110, 100, 105, 103, 101, 115, 116, 46, 111, 114, 103}, "UTF8").intern());
            builder.add(new String(new byte[]{73, 110, 122, 101, 115, 116}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 100, 122, 105, 108, 108, 97}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 45, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 45, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 45, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 105, 101, 45, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 45, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 45, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 45, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 100, 100, 121, 45, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 110, 100, 101, 114, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 110, 100, 101, 114, 32, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 110, 100, 101, 114, 45, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 110, 100, 101, 114, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 110, 100, 101, 114, 32, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 105, 110, 100, 101, 114, 45, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 117, 100, 100, 101, 108, 32, 57, 54}, "UTF8").intern());
            builder.add(new String(new byte[]{107, 117, 100, 100, 101, 108, 32, 39, 57, 54}, "UTF8").intern());
            builder.add(new String(new byte[]{109, 97, 102, 105, 97, 115, 101, 120, 46, 114, 117}, "UTF8").intern());
            builder.add(new String(new byte[]{77, 67, 76, 84, 32, 122, 101, 112, 39, 115, 32, 103, 117, 105, 100, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{77, 67, 76, 84, 32, 122, 101, 112, 115, 32, 103, 117, 105, 100, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{77, 67, 76, 84, 32, 122, 101, 112, 115, 103, 117, 105, 100, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 97, 107, 101, 100, 99, 104, 105, 108, 100, 114, 101, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 97, 107, 101, 100, 45, 99, 104, 105, 108, 100, 114, 101, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 101, 101, 116, 101, 114, 112}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 99, 104, 105, 108, 100, 114, 101, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 45, 99, 104, 105, 108, 100, 114, 101, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 107, 105, 100, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 45, 107, 105, 100, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 108, 105, 116, 116, 108, 101, 98, 111, 121, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 45, 108, 105, 116, 116, 108, 101, 45, 98, 111, 121, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 108, 105, 116, 116, 108, 101, 103, 105, 114, 108, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 45, 108, 105, 116, 116, 108, 101, 45, 103, 105, 114, 108, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 112, 114, 101, 116, 101, 101, 110, 103, 105, 114, 108, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{110, 117, 100, 101, 45, 112, 114, 101, 116, 101, 101, 110, 45, 103, 105, 32, 114, 108, 32, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 45, 102, 117, 99, 107}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 104, 97, 114, 100, 99, 111, 114, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 45, 104, 97, 114, 100, 99, 111, 114, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 108, 111, 118, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 101, 100, 111, 45, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 110, 117, 100, 101, 103, 105, 114, 108, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 45, 110, 117, 100, 101, 45, 103, 105, 114, 108, 32, 115}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 110, 117, 100, 105, 115, 116}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 45, 110, 117, 100, 105, 115, 116}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 45, 112, 111, 114, 110}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 112, 111, 114, 97, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 45, 112, 111, 114, 110, 111}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{112, 114, 101, 116, 101, 101, 110, 45, 115, 101, 120}, "UTF8").intern());
            builder.add(new String(new byte[]{113, 113, 97, 97, 122, 122}, "UTF8").intern());
            builder.add(new String(new byte[]{114, 64, 121, 103, 111, 108, 100}, "UTF8").intern());
            builder.add(new String(new byte[]{114, 105, 122, 109, 97, 115, 116, 97, 114}, "UTF8").intern());
            builder.add(new String(new byte[]{119, 97, 108, 101, 32, 116, 104, 101, 32, 112, 101, 100, 111, 102, 105, 108, 101}, "UTF8").intern());
            builder.add(new String(new byte[]{119, 97, 108, 101, 45, 116, 104, 101, 45, 112, 101, 100, 111, 102, 105, 108, 101}, "UTF8").intern());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return builder.build();
    }

    @Override
    public boolean allow(Message m) {
        if (m instanceof QueryRequest) {
            return !this.isBanned(((QueryRequest)m).getQuery());
        }
        return true;
    }

    @Override
    public boolean allow(QueryReply qr, Response response) {
        if (this.isBanned(response.getName())) {
            return false;
        }
        LimeXMLDocument doc = response.getDocument();
        return doc == null || this.allowDoc(doc);
    }

    private boolean isBanned(String input) {
        String canonical = input.toLowerCase(Locale.US);
        for (String word : this.ban) {
            int idx = canonical.indexOf(word);
            if (idx == -1 || idx != 0 && canonical.charAt(idx - 1) != ' ' || word.length() + idx != canonical.length() && canonical.charAt(word.length() + idx) != ' ') continue;
            return true;
        }
        return false;
    }

    private boolean allowDoc(LimeXMLDocument doc) {
        for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
            if (!this.isBanned(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

