/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.net.SocketAcceptor;
import org.limewire.service.MessageService;

@EagerSingleton
public class LocalAcceptor
implements Service {
    private static final int FIRST_PORT = 45100;
    private final SocketAcceptor acceptor;

    @Inject
    public LocalAcceptor(@Named(value="local") ConnectionDispatcher connectionDispatcher) {
        this.acceptor = new SocketAcceptor(connectionDispatcher);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Local Socket Listener");
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        if (!this.bind(45100)) {
            MessageService.showError(I18nMarker.marktr("LimeWire was unable to set up a port to listen for incoming connections. Some features of LimeWire may not work as expected."));
        }
    }

    @Override
    public void stop() {
        this.acceptor.unbind();
    }

    private boolean bind(int listeningPort) {
        for (int i = 0; i < 20; ++i) {
            try {
                this.acceptor.bind(listeningPort + i);
                return true;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return false;
    }

    public int getPort() {
        return this.acceptor.getPort();
    }

    public ConnectionDispatcher getDispatcher() {
        return this.acceptor.getDispatcher();
    }
}

