/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;

@EagerSingleton
public class OutOfBandThroughputMeasurer
implements Service {
    private static final Log LOG = LogFactory.getLog(OutOfBandThroughputMeasurer.class);
    private final ScheduledExecutorService backgroundExecutor;
    private final OutOfBandStatistics outOfBandStatistics;

    @Inject
    public OutOfBandThroughputMeasurer(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, OutOfBandStatistics outOfBandStatistics) {
        this.backgroundExecutor = backgroundExecutor;
        this.outOfBandStatistics = outOfBandStatistics;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return "OOB Throughput Measurer";
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
        Runnable adjuster = new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("current success rate " + OutOfBandThroughputMeasurer.this.outOfBandStatistics.getSuccessRate() + " based on " + OutOfBandThroughputMeasurer.this.outOfBandStatistics.getRequestedResponses() + " measurements with a min sample size " + OutOfBandThroughputMeasurer.this.outOfBandStatistics.getSampleSize());
                }
                if (!OutOfBandThroughputMeasurer.this.outOfBandStatistics.isSuccessRateGreat() && !OutOfBandThroughputMeasurer.this.outOfBandStatistics.isSuccessRateTerrible()) {
                    LOG.debug("boosting sample size");
                    OutOfBandThroughputMeasurer.this.outOfBandStatistics.increaseSampleSize();
                }
            }
        };
        int thirtyMins = 1800000;
        this.backgroundExecutor.scheduleWithFixedDelay(adjuster, thirtyMins, thirtyMins, TimeUnit.MILLISECONDS);
    }
}

